/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.ConfirmExperimentalFeaturesScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldCallback;
import net.minecraft.client.gui.screens.worldselection.DataPackReloadCookie;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.client.gui.screens.worldselection.ExperimentsScreen;
import net.minecraft.client.gui.screens.worldselection.InitialWorldCreationOptions;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.SwitchGrid;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContextMapper;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPresets;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class CreateWorldScreen
extends Screen {
    private static final int GROUP_BOTTOM = 1;
    private static final int TAB_COLUMN_WIDTH = 210;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TEMP_WORLD_PREFIX = "mcworld-";
    static final Component GAME_MODEL_LABEL = Component.translatable("selectWorld.gameMode");
    static final Component NAME_LABEL = Component.translatable("selectWorld.enterName");
    static final Component EXPERIMENTS_LABEL = Component.translatable("selectWorld.experiments");
    static final Component ALLOW_COMMANDS_INFO = Component.translatable("selectWorld.allowCommands.info");
    private static final Component PREPARING_WORLD_DATA = Component.translatable("createWorld.preparing");
    private static final int HORIZONTAL_BUTTON_SPACING = 10;
    private static final int VERTICAL_BUTTON_SPACING = 8;
    public static final ResourceLocation TAB_HEADER_BACKGROUND = ResourceLocation.withDefaultNamespace("textures/gui/tab_header_background.png");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    final WorldCreationUiState uiState;
    private final TabManager tabManager = new TabManager(p_386222_ -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(p_386222_);
    }, p_321370_ -> this.removeWidget((GuiEventListener)p_321370_));
    private boolean recreated;
    private final DirectoryValidator packValidator;
    private final CreateWorldCallback createWorldCallback;
    @Nullable
    private final Screen lastScreen;
    @Nullable
    private Path tempDataPackDir;
    @Nullable
    private PackRepository tempDataPackRepository;
    @Nullable
    private TabNavigationBar tabNavigationBar;

    public static void openFresh(Minecraft p_232897_, @Nullable Screen p_232898_) {
        CreateWorldScreen.openFresh(p_232897_, p_232898_, (p_373659_, p_373660_, p_373661_, p_373662_) -> p_373659_.createNewWorld(p_373660_, p_373661_));
    }

    public static void openFresh(Minecraft p_374172_, @Nullable Screen p_374534_, CreateWorldCallback p_374333_) {
        WorldCreationContextMapper $$3 = (p_372525_, p_372526_, p_372527_) -> new WorldCreationContext(p_372527_.worldGenSettings(), p_372526_, p_372525_, p_372527_.dataConfiguration());
        Function<WorldLoader.DataLoadContext, WorldGenSettings> $$4 = p_372520_ -> new WorldGenSettings(WorldOptions.defaultWithRandomSeed(), WorldPresets.createNormalWorldDimensions(p_372520_.datapackWorldgen()));
        CreateWorldScreen.openCreateWorldScreen(p_374172_, p_374534_, $$4, $$3, WorldPresets.NORMAL, p_374333_);
    }

    public static void testWorld(Minecraft p_372996_, @Nullable Screen p_372908_) {
        WorldCreationContextMapper $$2 = (p_372521_, p_372522_, p_372523_) -> new WorldCreationContext(p_372523_.worldGenSettings().options(), p_372523_.worldGenSettings().dimensions(), p_372522_, p_372521_, p_372523_.dataConfiguration(), new InitialWorldCreationOptions(WorldCreationUiState.SelectedGameMode.CREATIVE, Set.of(GameRules.RULE_DAYLIGHT, GameRules.RULE_WEATHER_CYCLE, GameRules.RULE_DOMOBSPAWNING), FlatLevelGeneratorPresets.REDSTONE_READY));
        Function<WorldLoader.DataLoadContext, WorldGenSettings> $$3 = p_372524_ -> new WorldGenSettings(WorldOptions.testWorldWithRandomSeed(), WorldPresets.createFlatWorldDimensions(p_372524_.datapackWorldgen()));
        CreateWorldScreen.openCreateWorldScreen(p_372996_, p_372908_, $$3, $$2, WorldPresets.FLAT, (p_373666_, p_373667_, p_373668_, p_373669_) -> p_373666_.createNewWorld(p_373667_, p_373668_));
    }

    private static void openCreateWorldScreen(Minecraft p_372818_, @Nullable Screen p_373021_, Function<WorldLoader.DataLoadContext, WorldGenSettings> p_372913_, WorldCreationContextMapper p_372864_, ResourceKey<WorldPreset> p_372962_, CreateWorldCallback p_374549_) {
        CreateWorldScreen.queueLoadScreen(p_372818_, PREPARING_WORLD_DATA);
        PackRepository $$6 = new PackRepository(new ServerPacksSource(p_372818_.directoryValidator()));
        WorldDataConfiguration $$7 = SharedConstants.IS_RUNNING_IN_IDE ? new WorldDataConfiguration(new DataPackConfig(List.of("vanilla", "tests"), List.of()), FeatureFlags.DEFAULT_FLAGS) : WorldDataConfiguration.DEFAULT;
        WorldLoader.InitConfig $$8 = CreateWorldScreen.createDefaultLoadConfig($$6, $$7);
        CompletableFuture<WorldCreationContext> $$9 = WorldLoader.load($$8, p_372510_ -> new WorldLoader.DataLoadOutput<DataPackReloadCookie>(new DataPackReloadCookie((WorldGenSettings)p_372913_.apply(p_372510_), p_372510_.dataConfiguration()), p_372510_.datapackDimensions()), (p_372512_, p_372513_, p_372514_, p_372515_) -> {
            p_372512_.close();
            return p_372864_.apply(p_372513_, p_372514_, (DataPackReloadCookie)p_372515_);
        }, Util.backgroundExecutor(), p_372818_);
        p_372818_.managedBlock($$9::isDone);
        p_372818_.setScreen(new CreateWorldScreen(p_372818_, p_373021_, $$9.join(), Optional.of(p_372962_), OptionalLong.empty(), p_374549_));
    }

    public static CreateWorldScreen createFromExisting(Minecraft p_276017_, @Nullable Screen p_276029_, LevelSettings p_276055_, WorldCreationContext p_276028_, @Nullable Path p_276040_) {
        CreateWorldScreen $$5 = new CreateWorldScreen(p_276017_, p_276029_, p_276028_, WorldPresets.fromSettings(p_276028_.selectedDimensions()), OptionalLong.of(p_276028_.options().seed()), (p_373670_, p_373671_, p_373672_, p_373673_) -> p_373670_.createNewWorld(p_373671_, p_373672_));
        $$5.recreated = true;
        $$5.uiState.setName(p_276055_.levelName());
        $$5.uiState.setAllowCommands(p_276055_.allowCommands());
        $$5.uiState.setDifficulty(p_276055_.difficulty());
        $$5.uiState.getGameRules().assignFrom(p_276055_.gameRules(), null);
        if (p_276055_.hardcore()) {
            $$5.uiState.setGameMode(WorldCreationUiState.SelectedGameMode.HARDCORE);
        } else if (p_276055_.gameType().isSurvival()) {
            $$5.uiState.setGameMode(WorldCreationUiState.SelectedGameMode.SURVIVAL);
        } else if (p_276055_.gameType().isCreative()) {
            $$5.uiState.setGameMode(WorldCreationUiState.SelectedGameMode.CREATIVE);
        }
        $$5.tempDataPackDir = p_276040_;
        return $$5;
    }

    private CreateWorldScreen(Minecraft p_276053_, @Nullable Screen p_276049_, WorldCreationContext p_276047_, Optional<ResourceKey<WorldPreset>> p_276013_, OptionalLong p_276031_, CreateWorldCallback p_374578_) {
        super(Component.translatable("selectWorld.create"));
        this.lastScreen = p_276049_;
        this.packValidator = p_276053_.directoryValidator();
        this.createWorldCallback = p_374578_;
        this.uiState = new WorldCreationUiState(p_276053_.getLevelSource().getBaseDir(), p_276047_, p_276013_, p_276031_);
    }

    public WorldCreationUiState getUiState() {
        return this.uiState;
    }

    @Override
    protected void init() {
        this.tabNavigationBar = TabNavigationBar.builder(this.tabManager, this.width).addTabs(new GameTab(), new WorldTab(), new MoreTab()).build();
        this.addRenderableWidget(this.tabNavigationBar);
        LinearLayout $$0 = this.layout.addToFooter(LinearLayout.horizontal().spacing(8));
        $$0.addChild(Button.builder(Component.translatable("selectWorld.create"), p_232938_ -> this.onCreate()).build());
        $$0.addChild(Button.builder(CommonComponents.GUI_CANCEL, p_232903_ -> this.popScreen()).build());
        this.layout.visitWidgets(p_386220_ -> {
            p_386220_.setTabOrderGroup(1);
            this.addRenderableWidget(p_386220_);
        });
        this.tabNavigationBar.selectTab(0, false);
        this.uiState.onChanged();
        this.repositionElements();
    }

    @Override
    protected void setInitialFocus() {
    }

    @Override
    public void repositionElements() {
        if (this.tabNavigationBar == null) {
            return;
        }
        this.tabNavigationBar.setWidth(this.width);
        this.tabNavigationBar.arrangeElements();
        int $$0 = this.tabNavigationBar.getRectangle().bottom();
        ScreenRectangle $$1 = new ScreenRectangle(0, $$0, this.width, this.height - this.layout.getFooterHeight() - $$0);
        this.tabManager.setTabArea($$1);
        this.layout.setHeaderHeight($$0);
        this.layout.arrangeElements();
    }

    private static void queueLoadScreen(Minecraft p_232900_, Component p_232901_) {
        p_232900_.forceSetScreen(new GenericMessageScreen(p_232901_));
    }

    private void onCreate() {
        WorldCreationContext $$0 = this.uiState.getSettings();
        WorldDimensions.Complete $$1 = $$0.selectedDimensions().bake($$0.datapackDimensions());
        LayeredRegistryAccess<RegistryLayer> $$2 = $$0.worldgenRegistries().replaceFrom(RegistryLayer.DIMENSIONS, $$1.dimensionsRegistryAccess());
        Lifecycle $$3 = FeatureFlags.isExperimental($$0.dataConfiguration().enabledFeatures()) ? Lifecycle.experimental() : Lifecycle.stable();
        Lifecycle $$4 = $$2.compositeAccess().allRegistriesLifecycle();
        Lifecycle $$5 = $$4.add($$3);
        boolean $$6 = !this.recreated && $$4 == Lifecycle.stable();
        LevelSettings $$7 = this.createLevelSettings($$1.specialWorldProperty() == PrimaryLevelData.SpecialWorldProperty.DEBUG);
        PrimaryLevelData $$8 = new PrimaryLevelData($$7, this.uiState.getSettings().options(), $$1.specialWorldProperty(), $$5);
        WorldOpenFlows.confirmWorldCreation(this.minecraft, this, $$5, () -> this.createWorldAndCleanup($$2, $$8), $$6);
    }

    private void createWorldAndCleanup(LayeredRegistryAccess<RegistryLayer> p_374105_, PrimaryLevelData p_374321_) {
        boolean $$2 = this.createWorldCallback.create(this, p_374105_, p_374321_, this.tempDataPackDir);
        this.removeTempDataPackDir();
        if (!$$2) {
            this.popScreen();
        }
    }

    private boolean createNewWorld(LayeredRegistryAccess<RegistryLayer> p_249152_, WorldData p_374211_) {
        String $$2 = this.uiState.getTargetFolder();
        WorldCreationContext $$3 = this.uiState.getSettings();
        CreateWorldScreen.queueLoadScreen(this.minecraft, PREPARING_WORLD_DATA);
        Optional<LevelStorageSource.LevelStorageAccess> $$4 = CreateWorldScreen.createNewWorldDirectory(this.minecraft, $$2, this.tempDataPackDir);
        if ($$4.isEmpty()) {
            SystemToast.onPackCopyFailure(this.minecraft, $$2);
            return false;
        }
        this.minecraft.createWorldOpenFlows().createLevelFromExistingSettings($$4.get(), $$3.dataPackResources(), p_249152_, p_374211_);
        return true;
    }

    private LevelSettings createLevelSettings(boolean p_205448_) {
        String $$1 = this.uiState.getName().trim();
        if (p_205448_) {
            GameRules $$2 = new GameRules(WorldDataConfiguration.DEFAULT.enabledFeatures());
            $$2.getRule(GameRules.RULE_DAYLIGHT).set(false, null);
            return new LevelSettings($$1, GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, $$2, WorldDataConfiguration.DEFAULT);
        }
        return new LevelSettings($$1, this.uiState.getGameMode().gameType, this.uiState.isHardcore(), this.uiState.getDifficulty(), this.uiState.isAllowCommands(), this.uiState.getGameRules(), this.uiState.getSettings().dataConfiguration());
    }

    @Override
    public boolean keyPressed(int p_100875_, int p_100876_, int p_100877_) {
        if (this.tabNavigationBar.keyPressed(p_100875_)) {
            return true;
        }
        if (super.keyPressed(p_100875_, p_100876_, p_100877_)) {
            return true;
        }
        if (p_100875_ == 257 || p_100875_ == 335) {
            this.onCreate();
            return true;
        }
        return false;
    }

    @Override
    public void onClose() {
        this.popScreen();
    }

    public void popScreen() {
        this.minecraft.setScreen(this.lastScreen);
        this.removeTempDataPackDir();
    }

    @Override
    public void render(GuiGraphics p_282137_, int p_283640_, int p_281243_, float p_282743_) {
        super.render(p_282137_, p_283640_, p_281243_, p_282743_);
        p_282137_.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - this.layout.getFooterHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
    }

    @Override
    protected void renderMenuBackground(GuiGraphics p_331389_) {
        p_331389_.blit(RenderPipelines.GUI_TEXTURED, TAB_HEADER_BACKGROUND, 0, 0, 0.0f, 0.0f, this.width, this.layout.getHeaderHeight(), 16, 16);
        this.renderMenuBackground(p_331389_, 0, this.layout.getHeaderHeight(), this.width, this.height);
    }

    @Nullable
    private Path getOrCreateTempDataPackDir() {
        if (this.tempDataPackDir == null) {
            try {
                this.tempDataPackDir = Files.createTempDirectory(TEMP_WORLD_PREFIX, new FileAttribute[0]);
            }
            catch (IOException $$0) {
                LOGGER.warn("Failed to create temporary dir", (Throwable)$$0);
                SystemToast.onPackCopyFailure(this.minecraft, this.uiState.getTargetFolder());
                this.popScreen();
            }
        }
        return this.tempDataPackDir;
    }

    void openExperimentsScreen(WorldDataConfiguration p_270214_) {
        Pair<Path, PackRepository> $$1 = this.getDataPackSelectionSettings(p_270214_);
        if ($$1 != null) {
            this.minecraft.setScreen(new ExperimentsScreen(this, (PackRepository)$$1.getSecond(), p_269636_ -> this.tryApplyNewDataPacks((PackRepository)p_269636_, false, this::openExperimentsScreen)));
        }
    }

    void openDataPackSelectionScreen(WorldDataConfiguration p_268186_) {
        Pair<Path, PackRepository> $$1 = this.getDataPackSelectionSettings(p_268186_);
        if ($$1 != null) {
            this.minecraft.setScreen(new PackSelectionScreen((PackRepository)$$1.getSecond(), p_269637_ -> this.tryApplyNewDataPacks((PackRepository)p_269637_, true, this::openDataPackSelectionScreen), (Path)$$1.getFirst(), Component.translatable("dataPack.title")));
        }
    }

    private void tryApplyNewDataPacks(PackRepository p_270299_, boolean p_270896_, Consumer<WorldDataConfiguration> p_270760_) {
        List $$4;
        ImmutableList $$3 = ImmutableList.copyOf(p_270299_.getSelectedIds());
        WorldDataConfiguration $$5 = new WorldDataConfiguration(new DataPackConfig((List<String>)$$3, $$4 = (List)p_270299_.getAvailableIds().stream().filter(arg_0 -> CreateWorldScreen.lambda$tryApplyNewDataPacks$17((List)$$3, arg_0)).collect(ImmutableList.toImmutableList())), this.uiState.getSettings().dataConfiguration().enabledFeatures());
        if (this.uiState.tryUpdateDataConfiguration($$5)) {
            this.minecraft.setScreen(this);
            return;
        }
        FeatureFlagSet $$6 = p_270299_.getRequestedFeatureFlags();
        if (FeatureFlags.isExperimental($$6) && p_270896_) {
            this.minecraft.setScreen(new ConfirmExperimentalFeaturesScreen(p_270299_.getSelectedPacks(), p_269635_ -> {
                if (p_269635_) {
                    this.applyNewPackConfig(p_270299_, $$5, p_270760_);
                } else {
                    p_270760_.accept(this.uiState.getSettings().dataConfiguration());
                }
            }));
        } else {
            this.applyNewPackConfig(p_270299_, $$5, p_270760_);
        }
    }

    private void applyNewPackConfig(PackRepository p_270272_, WorldDataConfiguration p_270573_, Consumer<WorldDataConfiguration> p_270552_) {
        this.minecraft.forceSetScreen(new GenericMessageScreen(Component.translatable("dataPack.validation.working")));
        WorldLoader.InitConfig $$3 = CreateWorldScreen.createDefaultLoadConfig(p_270272_, p_270573_);
        ((CompletableFuture)((CompletableFuture)WorldLoader.load($$3, p_326721_ -> {
            if (p_326721_.datapackWorldgen().lookupOrThrow(Registries.WORLD_PRESET).listElements().findAny().isEmpty()) {
                throw new IllegalStateException("Needs at least one world preset to continue");
            }
            if (p_326721_.datapackWorldgen().lookupOrThrow(Registries.BIOME).listElements().findAny().isEmpty()) {
                throw new IllegalStateException("Needs at least one biome continue");
            }
            WorldCreationContext $$1 = this.uiState.getSettings();
            RegistryOps $$2 = $$1.worldgenLoadContext().createSerializationContext(JsonOps.INSTANCE);
            DataResult $$3 = WorldGenSettings.encode($$2, $$1.options(), $$1.selectedDimensions()).setLifecycle(Lifecycle.stable());
            RegistryOps $$4 = p_326721_.datapackWorldgen().createSerializationContext(JsonOps.INSTANCE);
            WorldGenSettings $$5 = (WorldGenSettings)$$3.flatMap(p_232895_ -> WorldGenSettings.CODEC.parse($$4, p_232895_)).getOrThrow(p_337413_ -> new IllegalStateException("Error parsing worldgen settings after loading data packs: " + p_337413_));
            return new WorldLoader.DataLoadOutput<DataPackReloadCookie>(new DataPackReloadCookie($$5, p_326721_.dataConfiguration()), p_326721_.datapackDimensions());
        }, (p_372516_, p_372517_, p_372518_, p_372519_) -> {
            p_372516_.close();
            return new WorldCreationContext(p_372519_.worldGenSettings(), p_372518_, p_372517_, p_372519_.dataConfiguration());
        }, Util.backgroundExecutor(), this.minecraft).thenApply(p_344162_ -> {
            p_344162_.validate();
            return p_344162_;
        })).thenAcceptAsync(this.uiState::setSettings, (Executor)this.minecraft)).handleAsync((p_280900_, p_280901_) -> {
            if (p_280901_ != null) {
                LOGGER.warn("Failed to validate datapack", p_280901_);
                this.minecraft.setScreen(new ConfirmScreen(p_269627_ -> {
                    if (p_269627_) {
                        p_270552_.accept(this.uiState.getSettings().dataConfiguration());
                    } else {
                        p_270552_.accept(WorldDataConfiguration.DEFAULT);
                    }
                }, Component.translatable("dataPack.validation.failed"), CommonComponents.EMPTY, Component.translatable("dataPack.validation.back"), Component.translatable("dataPack.validation.reset")));
            } else {
                this.minecraft.setScreen(this);
            }
            return null;
        }, (Executor)this.minecraft);
    }

    private static WorldLoader.InitConfig createDefaultLoadConfig(PackRepository p_251829_, WorldDataConfiguration p_251555_) {
        WorldLoader.PackConfig $$2 = new WorldLoader.PackConfig(p_251829_, p_251555_, false, true);
        return new WorldLoader.InitConfig($$2, Commands.CommandSelection.INTEGRATED, 2);
    }

    private void removeTempDataPackDir() {
        if (this.tempDataPackDir != null && Files.exists(this.tempDataPackDir, new LinkOption[0])) {
            try (Stream<Path> $$0 = Files.walk(this.tempDataPackDir, new FileVisitOption[0]);){
                $$0.sorted(Comparator.reverseOrder()).forEach(p_232942_ -> {
                    try {
                        Files.delete(p_232942_);
                    }
                    catch (IOException $$1) {
                        LOGGER.warn("Failed to remove temporary file {}", p_232942_, (Object)$$1);
                    }
                });
            }
            catch (IOException $$1) {
                LOGGER.warn("Failed to list temporary dir {}", (Object)this.tempDataPackDir);
            }
        }
        this.tempDataPackDir = null;
    }

    private static void copyBetweenDirs(Path p_100913_, Path p_100914_, Path p_100915_) {
        try {
            Util.copyBetweenDirs(p_100913_, p_100914_, p_100915_);
        }
        catch (IOException $$3) {
            LOGGER.warn("Failed to copy datapack file from {} to {}", (Object)p_100915_, (Object)p_100914_);
            throw new UncheckedIOException($$3);
        }
    }

    /*
     * WARNING - bad return control flow
     */
    private static Optional<LevelStorageSource.LevelStorageAccess> createNewWorldDirectory(Minecraft p_374135_, String p_374392_, @Nullable Path p_374465_) {
        Optional<LevelStorageSource.LevelStorageAccess> optional;
        block12: {
            LevelStorageSource.LevelStorageAccess $$3;
            block11: {
                $$3 = p_374135_.getLevelSource().createAccess(p_374392_);
                if (p_374465_ != null) break block11;
                return Optional.of($$3);
            }
            Stream<Path> $$4 = Files.walk(p_374465_, new FileVisitOption[0]);
            try {
                Path $$5 = $$3.getLevelPath(LevelResource.DATAPACK_DIR);
                FileUtil.createDirectoriesSafe($$5);
                $$4.filter(p_232924_ -> !p_232924_.equals(p_374465_)).forEach(p_373665_ -> CreateWorldScreen.copyBetweenDirs(p_374465_, $$5, p_373665_));
                optional = Optional.of($$3);
                if ($$4 == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if ($$4 != null) {
                            try {
                                $$4.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UncheckedIOException $$6) {
                        LOGGER.warn("Failed to copy datapacks to world {}", (Object)p_374392_, (Object)$$6);
                        $$3.close();
                    }
                }
                catch (IOException | UncheckedIOException $$7) {
                    LOGGER.warn("Failed to create access for {}", (Object)p_374392_, (Object)$$7);
                }
            }
            $$4.close();
        }
        return optional;
        return Optional.empty();
    }

    @Nullable
    public static Path createTempDataPackDirFromExistingWorld(Path p_100907_, Minecraft p_100908_) {
        MutableObject $$2 = new MutableObject();
        try (Stream<Path> $$3 = Files.walk(p_100907_, new FileVisitOption[0]);){
            $$3.filter(p_373677_ -> !p_373677_.equals(p_100907_)).forEach(p_232933_ -> {
                Path $$3 = (Path)$$2.getValue();
                if ($$3 == null) {
                    try {
                        $$3 = Files.createTempDirectory(TEMP_WORLD_PREFIX, new FileAttribute[0]);
                    }
                    catch (IOException $$4) {
                        LOGGER.warn("Failed to create temporary dir");
                        throw new UncheckedIOException($$4);
                    }
                    $$2.setValue((Object)$$3);
                }
                CreateWorldScreen.copyBetweenDirs(p_100907_, $$3, p_232933_);
            });
        }
        catch (IOException | UncheckedIOException $$4) {
            LOGGER.warn("Failed to copy datapacks from world {}", (Object)p_100907_, (Object)$$4);
            SystemToast.onPackCopyFailure(p_100908_, p_100907_.toString());
            return null;
        }
        return (Path)$$2.getValue();
    }

    @Nullable
    private Pair<Path, PackRepository> getDataPackSelectionSettings(WorldDataConfiguration p_268328_) {
        Path $$1 = this.getOrCreateTempDataPackDir();
        if ($$1 != null) {
            if (this.tempDataPackRepository == null) {
                this.tempDataPackRepository = ServerPacksSource.createPackRepository($$1, this.packValidator);
                this.tempDataPackRepository.reload();
            }
            this.tempDataPackRepository.setSelected(p_268328_.dataPacks().getEnabled());
            return Pair.of((Object)$$1, (Object)this.tempDataPackRepository);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$tryApplyNewDataPacks$17(List p_232926_, String p_232927_) {
        return !p_232926_.contains(p_232927_);
    }

    class GameTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.translatable("createWorld.tab.game.title");
        private static final Component ALLOW_COMMANDS = Component.translatable("selectWorld.allowCommands");
        private final EditBox nameEdit;

        GameTab() {
            super(TITLE);
            GridLayout.RowHelper $$0 = this.layout.rowSpacing(8).createRowHelper(1);
            LayoutSettings $$1 = $$0.newCellSettings();
            this.nameEdit = new EditBox(CreateWorldScreen.this.font, 208, 20, Component.translatable("selectWorld.enterName"));
            this.nameEdit.setValue(CreateWorldScreen.this.uiState.getName());
            this.nameEdit.setResponder(CreateWorldScreen.this.uiState::setName);
            CreateWorldScreen.this.uiState.addListener(p_275871_ -> this.nameEdit.setTooltip(Tooltip.create(Component.translatable("selectWorld.targetFolder", Component.literal(p_275871_.getTargetFolder()).withStyle(ChatFormatting.ITALIC)))));
            CreateWorldScreen.this.setInitialFocus(this.nameEdit);
            $$0.addChild(CommonLayouts.labeledElement(CreateWorldScreen.this.font, this.nameEdit, NAME_LABEL), $$0.newCellSettings().alignHorizontallyCenter());
            CycleButton<WorldCreationUiState.SelectedGameMode> $$2 = $$0.addChild(CycleButton.builder(p_268080_ -> p_268080_.displayName).withValues((WorldCreationUiState.SelectedGameMode[])new WorldCreationUiState.SelectedGameMode[]{WorldCreationUiState.SelectedGameMode.SURVIVAL, WorldCreationUiState.SelectedGameMode.HARDCORE, WorldCreationUiState.SelectedGameMode.CREATIVE}).create(0, 0, 210, 20, GAME_MODEL_LABEL, (p_268266_, p_268208_) -> CreateWorldScreen.this.uiState.setGameMode((WorldCreationUiState.SelectedGameMode)((Object)p_268208_))), $$1);
            CreateWorldScreen.this.uiState.addListener(p_280907_ -> {
                $$2.setValue(p_280907_.getGameMode());
                p_280906_.active = !p_280907_.isDebug();
                $$2.setTooltip(Tooltip.create(p_280907_.getGameMode().getInfo()));
            });
            CycleButton<Difficulty> $$3 = $$0.addChild(CycleButton.builder(Difficulty::getDisplayName).withValues((Difficulty[])Difficulty.values()).create(0, 0, 210, 20, Component.translatable("options.difficulty"), (p_267962_, p_268338_) -> CreateWorldScreen.this.uiState.setDifficulty((Difficulty)p_268338_)), $$1);
            CreateWorldScreen.this.uiState.addListener(p_280905_ -> {
                $$3.setValue(CreateWorldScreen.this.uiState.getDifficulty());
                p_280904_.active = !CreateWorldScreen.this.uiState.isHardcore();
                $$3.setTooltip(Tooltip.create(CreateWorldScreen.this.uiState.getDifficulty().getInfo()));
            });
            CycleButton<Boolean> $$4 = $$0.addChild(CycleButton.onOffBuilder().withTooltip(p_321371_ -> Tooltip.create(ALLOW_COMMANDS_INFO)).create(0, 0, 210, 20, ALLOW_COMMANDS, (p_321372_, p_321373_) -> CreateWorldScreen.this.uiState.setAllowCommands((boolean)p_321373_)));
            CreateWorldScreen.this.uiState.addListener(p_321375_ -> {
                $$4.setValue(CreateWorldScreen.this.uiState.isAllowCommands());
                p_321374_.active = !CreateWorldScreen.this.uiState.isDebug() && !CreateWorldScreen.this.uiState.isHardcore();
            });
            if (!SharedConstants.getCurrentVersion().stable()) {
                $$0.addChild(Button.builder(EXPERIMENTS_LABEL, p_269641_ -> CreateWorldScreen.this.openExperimentsScreen(CreateWorldScreen.this.uiState.getSettings().dataConfiguration())).width(210).build());
            }
        }
    }

    class WorldTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.translatable("createWorld.tab.world.title");
        private static final Component AMPLIFIED_HELP_TEXT = Component.translatable("generator.minecraft.amplified.info");
        private static final Component GENERATE_STRUCTURES = Component.translatable("selectWorld.mapFeatures");
        private static final Component GENERATE_STRUCTURES_INFO = Component.translatable("selectWorld.mapFeatures.info");
        private static final Component BONUS_CHEST = Component.translatable("selectWorld.bonusItems");
        private static final Component SEED_LABEL = Component.translatable("selectWorld.enterSeed");
        static final Component SEED_EMPTY_HINT = Component.translatable("selectWorld.seedInfo").withStyle(ChatFormatting.DARK_GRAY);
        private static final int WORLD_TAB_WIDTH = 310;
        private final EditBox seedEdit;
        private final Button customizeTypeButton;

        WorldTab() {
            super(TITLE);
            GridLayout.RowHelper $$0 = this.layout.columnSpacing(10).rowSpacing(8).createRowHelper(2);
            CycleButton<WorldCreationUiState.WorldTypeEntry> $$1 = $$0.addChild(CycleButton.builder(WorldCreationUiState.WorldTypeEntry::describePreset).withValues(this.createWorldTypeValueSupplier()).withCustomNarration(WorldTab::createTypeButtonNarration).create(0, 0, 150, 20, Component.translatable("selectWorld.mapType"), (p_268242_, p_267954_) -> CreateWorldScreen.this.uiState.setWorldType((WorldCreationUiState.WorldTypeEntry)p_267954_)));
            $$1.setValue(CreateWorldScreen.this.uiState.getWorldType());
            CreateWorldScreen.this.uiState.addListener(p_280909_ -> {
                WorldCreationUiState.WorldTypeEntry $$2 = p_280909_.getWorldType();
                $$1.setValue($$2);
                if ($$2.isAmplified()) {
                    $$1.setTooltip(Tooltip.create(AMPLIFIED_HELP_TEXT));
                } else {
                    $$1.setTooltip(null);
                }
                p_280908_.active = CreateWorldScreen.this.uiState.getWorldType().preset() != null;
            });
            this.customizeTypeButton = $$0.addChild(Button.builder(Component.translatable("selectWorld.customizeType"), p_268355_ -> this.openPresetEditor()).build());
            CreateWorldScreen.this.uiState.addListener(p_280910_ -> {
                this.customizeTypeButton.active = !p_280910_.isDebug() && p_280910_.getPresetEditor() != null;
            });
            this.seedEdit = new EditBox(this, CreateWorldScreen.this.font, 308, 20, Component.translatable("selectWorld.enterSeed")){

                @Override
                protected MutableComponent createNarrationMessage() {
                    return super.createNarrationMessage().append(CommonComponents.NARRATION_SEPARATOR).append(SEED_EMPTY_HINT);
                }
            };
            this.seedEdit.setHint(SEED_EMPTY_HINT);
            this.seedEdit.setValue(CreateWorldScreen.this.uiState.getSeed());
            this.seedEdit.setResponder(p_268342_ -> CreateWorldScreen.this.uiState.setSeed(this.seedEdit.getValue()));
            $$0.addChild(CommonLayouts.labeledElement(CreateWorldScreen.this.font, this.seedEdit, SEED_LABEL), 2);
            SwitchGrid.Builder $$2 = SwitchGrid.builder(310);
            $$2.addSwitch(GENERATE_STRUCTURES, CreateWorldScreen.this.uiState::isGenerateStructures, CreateWorldScreen.this.uiState::setGenerateStructures).withIsActiveCondition(() -> !CreateWorldScreen.this.uiState.isDebug()).withInfo(GENERATE_STRUCTURES_INFO);
            $$2.addSwitch(BONUS_CHEST, CreateWorldScreen.this.uiState::isBonusChest, CreateWorldScreen.this.uiState::setBonusChest).withIsActiveCondition(() -> !CreateWorldScreen.this.uiState.isHardcore() && !CreateWorldScreen.this.uiState.isDebug());
            SwitchGrid $$3 = $$2.build();
            $$0.addChild($$3.layout(), 2);
            CreateWorldScreen.this.uiState.addListener(p_268209_ -> $$3.refreshStates());
        }

        private void openPresetEditor() {
            PresetEditor $$0 = CreateWorldScreen.this.uiState.getPresetEditor();
            if ($$0 != null) {
                CreateWorldScreen.this.minecraft.setScreen($$0.createEditScreen(CreateWorldScreen.this, CreateWorldScreen.this.uiState.getSettings()));
            }
        }

        private CycleButton.ValueListSupplier<WorldCreationUiState.WorldTypeEntry> createWorldTypeValueSupplier() {
            return new CycleButton.ValueListSupplier<WorldCreationUiState.WorldTypeEntry>(){

                @Override
                public List<WorldCreationUiState.WorldTypeEntry> getSelectedList() {
                    return CycleButton.DEFAULT_ALT_LIST_SELECTOR.getAsBoolean() ? CreateWorldScreen.this.uiState.getAltPresetList() : CreateWorldScreen.this.uiState.getNormalPresetList();
                }

                @Override
                public List<WorldCreationUiState.WorldTypeEntry> getDefaultList() {
                    return CreateWorldScreen.this.uiState.getNormalPresetList();
                }
            };
        }

        private static MutableComponent createTypeButtonNarration(CycleButton<WorldCreationUiState.WorldTypeEntry> p_268292_) {
            if (p_268292_.getValue().isAmplified()) {
                return CommonComponents.joinForNarration(p_268292_.createDefaultNarrationMessage(), AMPLIFIED_HELP_TEXT);
            }
            return p_268292_.createDefaultNarrationMessage();
        }
    }

    class MoreTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.translatable("createWorld.tab.more.title");
        private static final Component GAME_RULES_LABEL = Component.translatable("selectWorld.gameRules");
        private static final Component DATA_PACKS_LABEL = Component.translatable("selectWorld.dataPacks");

        MoreTab() {
            super(TITLE);
            GridLayout.RowHelper $$0 = this.layout.rowSpacing(8).createRowHelper(1);
            $$0.addChild(Button.builder(GAME_RULES_LABEL, p_268028_ -> this.openGameRulesScreen()).width(210).build());
            $$0.addChild(Button.builder(EXPERIMENTS_LABEL, p_269642_ -> CreateWorldScreen.this.openExperimentsScreen(CreateWorldScreen.this.uiState.getSettings().dataConfiguration())).width(210).build());
            $$0.addChild(Button.builder(DATA_PACKS_LABEL, p_268345_ -> CreateWorldScreen.this.openDataPackSelectionScreen(CreateWorldScreen.this.uiState.getSettings().dataConfiguration())).width(210).build());
        }

        private void openGameRulesScreen() {
            CreateWorldScreen.this.minecraft.setScreen(new EditGameRulesScreen(CreateWorldScreen.this.uiState.getGameRules().copy(CreateWorldScreen.this.uiState.getSettings().dataConfiguration().enabledFeatures()), p_268107_ -> {
                CreateWorldScreen.this.minecraft.setScreen(CreateWorldScreen.this);
                p_268107_.ifPresent(CreateWorldScreen.this.uiState::setGameRules);
            }));
        }
    }
}

