/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

public class RecipeCollection {
    public static final RecipeCollection EMPTY = new RecipeCollection(List.of());
    private final List<RecipeDisplayEntry> entries;
    private final Set<RecipeDisplayId> craftable = new HashSet<RecipeDisplayId>();
    private final Set<RecipeDisplayId> selected = new HashSet<RecipeDisplayId>();

    public RecipeCollection(List<RecipeDisplayEntry> p_267051_) {
        this.entries = p_267051_;
    }

    public void selectRecipes(StackedItemContents p_379685_, Predicate<RecipeDisplay> p_379624_) {
        for (RecipeDisplayEntry $$2 : this.entries) {
            boolean $$3 = p_379624_.test($$2.display());
            if ($$3) {
                this.selected.add($$2.id());
            } else {
                this.selected.remove($$2.id());
            }
            if ($$3 && $$2.canCraft(p_379685_)) {
                this.craftable.add($$2.id());
                continue;
            }
            this.craftable.remove($$2.id());
        }
    }

    public boolean isCraftable(RecipeDisplayId p_379375_) {
        return this.craftable.contains(p_379375_);
    }

    public boolean hasCraftable() {
        return !this.craftable.isEmpty();
    }

    public boolean hasAnySelected() {
        return !this.selected.isEmpty();
    }

    public List<RecipeDisplayEntry> getRecipes() {
        return this.entries;
    }

    public List<RecipeDisplayEntry> getSelectedRecipes(CraftableStatus p_379340_) {
        Predicate<RecipeDisplayId> $$1 = switch (p_379340_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.selected::contains;
            case 1 -> this.craftable::contains;
            case 2 -> p_378796_ -> this.selected.contains(p_378796_) && !this.craftable.contains(p_378796_);
        };
        ArrayList<RecipeDisplayEntry> $$2 = new ArrayList<RecipeDisplayEntry>();
        for (RecipeDisplayEntry $$3 : this.entries) {
            if (!$$1.test($$3.id())) continue;
            $$2.add($$3);
        }
        return $$2;
    }

    public static enum CraftableStatus {
        ANY,
        CRAFTABLE,
        NOT_CRAFTABLE;

    }
}

