/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectsInInventory;
import net.minecraft.client.gui.screens.recipebook.CraftingRecipeBookComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class InventoryScreen
extends AbstractRecipeBookScreen<InventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean buttonClicked;
    private final EffectsInInventory effects;

    public InventoryScreen(Player p_98839_) {
        super(p_98839_.inventoryMenu, new CraftingRecipeBookComponent(p_98839_.inventoryMenu), p_98839_.getInventory(), Component.translatable("container.crafting"));
        this.titleLabelX = 97;
        this.effects = new EffectsInInventory(this);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.minecraft.player.hasInfiniteMaterials()) {
            this.minecraft.setScreen(new CreativeModeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), this.minecraft.options.operatorItemsTab().get()));
        }
    }

    @Override
    protected void init() {
        if (this.minecraft.player.hasInfiniteMaterials()) {
            this.minecraft.setScreen(new CreativeModeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), this.minecraft.options.operatorItemsTab().get()));
            return;
        }
        super.init();
    }

    @Override
    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 104, this.height / 2 - 22);
    }

    @Override
    protected void onRecipeBookButtonClick() {
        this.buttonClicked = true;
    }

    @Override
    protected void renderLabels(GuiGraphics p_281654_, int p_283517_, int p_283464_) {
        p_281654_.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
    }

    @Override
    public void render(GuiGraphics p_283246_, int p_98876_, int p_98877_, float p_98878_) {
        this.effects.renderEffects(p_283246_, p_98876_, p_98877_);
        super.render(p_283246_, p_98876_, p_98877_, p_98878_);
        this.effects.renderTooltip(p_283246_, p_98876_, p_98877_);
        this.xMouse = p_98876_;
        this.yMouse = p_98877_;
    }

    @Override
    public boolean showsActiveEffects() {
        return this.effects.canSeeEffects();
    }

    @Override
    protected boolean isBiggerResultSlot() {
        return false;
    }

    @Override
    protected void renderBg(GuiGraphics p_281500_, float p_281299_, int p_283481_, int p_281831_) {
        int $$4 = this.leftPos;
        int $$5 = this.topPos;
        p_281500_.blit(RenderPipelines.GUI_TEXTURED, INVENTORY_LOCATION, $$4, $$5, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        InventoryScreen.renderEntityInInventoryFollowsMouse(p_281500_, $$4 + 26, $$5 + 8, $$4 + 75, $$5 + 78, 30, 0.0625f, this.xMouse, this.yMouse, this.minecraft.player);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics p_282802_, int p_275688_, int p_275245_, int p_275535_, int p_294406_, int p_294663_, float p_275604_, float p_275546_, float p_295352_, LivingEntity p_275689_) {
        float $$10 = (float)(p_275688_ + p_275535_) / 2.0f;
        float $$11 = (float)(p_275245_ + p_294406_) / 2.0f;
        p_282802_.enableScissor(p_275688_, p_275245_, p_275535_, p_294406_);
        float $$12 = (float)Math.atan(($$10 - p_275546_) / 40.0f);
        float $$13 = (float)Math.atan(($$11 - p_295352_) / 40.0f);
        Quaternionf $$14 = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf $$15 = new Quaternionf().rotateX($$13 * 20.0f * ((float)Math.PI / 180));
        $$14.mul((Quaternionfc)$$15);
        float $$16 = p_275689_.yBodyRot;
        float $$17 = p_275689_.getYRot();
        float $$18 = p_275689_.getXRot();
        float $$19 = p_275689_.yHeadRotO;
        float $$20 = p_275689_.yHeadRot;
        p_275689_.yBodyRot = 180.0f + $$12 * 20.0f;
        p_275689_.setYRot(180.0f + $$12 * 40.0f);
        p_275689_.setXRot(-$$13 * 20.0f);
        p_275689_.yHeadRot = p_275689_.getYRot();
        p_275689_.yHeadRotO = p_275689_.getYRot();
        float $$21 = p_275689_.getScale();
        Vector3f $$22 = new Vector3f(0.0f, p_275689_.getBbHeight() / 2.0f + p_275604_ * $$21, 0.0f);
        float $$23 = (float)p_294663_ / $$21;
        InventoryScreen.renderEntityInInventory(p_282802_, p_275688_, p_275245_, p_275535_, p_294406_, $$23, $$22, $$14, $$15, p_275689_);
        p_275689_.yBodyRot = $$16;
        p_275689_.setYRot($$17);
        p_275689_.setXRot($$18);
        p_275689_.yHeadRotO = $$19;
        p_275689_.yHeadRot = $$20;
        p_282802_.disableScissor();
    }

    public static void renderEntityInInventory(GuiGraphics p_282665_, int p_416436_, int p_416211_, int p_416017_, int p_416187_, float p_296361_, Vector3f p_295026_, Quaternionf p_281880_, @Nullable Quaternionf p_282882_, LivingEntity p_282466_) {
        EntityRenderDispatcher $$10 = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer<?, LivingEntity> $$11 = $$10.getRenderer(p_282466_);
        LivingEntity $$12 = $$11.createRenderState(p_282466_, 1.0f);
        ((EntityRenderState)((Object)$$12)).hitboxesRenderState = null;
        p_282665_.submitEntityRenderState((EntityRenderState)((Object)$$12), p_296361_, p_295026_, p_281880_, p_282882_, p_416436_, p_416211_, p_416017_, p_416187_);
    }

    @Override
    public boolean mouseReleased(double p_98893_, double p_98894_, int p_98895_) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(p_98893_, p_98894_, p_98895_);
    }
}

