/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class BookSignScreen
extends Screen {
    private static final Component EDIT_TITLE_LABEL = Component.translatable("book.editTitle");
    private static final Component FINALIZE_WARNING_LABEL = Component.translatable("book.finalizeWarning");
    private static final Component TITLE = Component.translatable("book.sign.title");
    private static final Component TITLE_EDIT_BOX = Component.translatable("book.sign.titlebox");
    private final BookEditScreen bookEditScreen;
    private final Player owner;
    private final List<String> pages;
    private final InteractionHand hand;
    private final Component ownerText;
    private EditBox titleBox;
    private String titleValue = "";

    public BookSignScreen(BookEditScreen p_421637_, Player p_422514_, InteractionHand p_422505_, List<String> p_422406_) {
        super(TITLE);
        this.bookEditScreen = p_421637_;
        this.owner = p_422514_;
        this.hand = p_422505_;
        this.pages = p_422406_;
        this.ownerText = Component.translatable("book.byAuthor", p_422514_.getName()).withStyle(ChatFormatting.DARK_GRAY);
    }

    @Override
    protected void init() {
        Button $$0 = Button.builder(Component.translatable("book.finalizeButton"), p_421961_ -> {
            this.saveChanges();
            this.minecraft.setScreen(null);
        }).bounds(this.width / 2 - 100, 196, 98, 20).build();
        $$0.active = false;
        this.titleBox = this.addRenderableWidget(new EditBox(this.minecraft.font, (this.width - 114) / 2 - 3, 50, 114, 20, TITLE_EDIT_BOX));
        this.titleBox.setMaxLength(15);
        this.titleBox.setBordered(false);
        this.titleBox.setCentered(true);
        this.titleBox.setTextColor(-16777216);
        this.titleBox.setTextShadow(false);
        this.titleBox.setResponder(p_422528_ -> {
            p_421595_.active = !StringUtil.isBlank(p_422528_);
        });
        this.titleBox.setValue(this.titleValue);
        this.addRenderableWidget($$0);
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_422253_ -> {
            this.titleValue = this.titleBox.getValue();
            this.minecraft.setScreen(this.bookEditScreen);
        }).bounds(this.width / 2 + 2, 196, 98, 20).build());
    }

    @Override
    protected void setInitialFocus() {
        this.setInitialFocus(this.titleBox);
    }

    private void saveChanges() {
        int $$0 = this.hand == InteractionHand.MAIN_HAND ? this.owner.getInventory().getSelectedSlot() : 40;
        this.minecraft.getConnection().send(new ServerboundEditBookPacket($$0, this.pages, Optional.of(this.titleBox.getValue().trim())));
    }

    @Override
    public boolean keyPressed(int p_421798_, int p_421882_, int p_421984_) {
        if (this.titleBox.isFocused() && !this.titleBox.getValue().isEmpty() && (p_421798_ == 257 || p_421798_ == 335)) {
            this.saveChanges();
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(p_421798_, p_421882_, p_421984_);
    }

    @Override
    public void render(GuiGraphics p_422561_, int p_421651_, int p_421594_, float p_422678_) {
        super.render(p_422561_, p_421651_, p_421594_, p_422678_);
        int $$4 = (this.width - 192) / 2;
        int $$5 = 2;
        int $$6 = this.font.width(EDIT_TITLE_LABEL);
        p_422561_.drawString(this.font, EDIT_TITLE_LABEL, $$4 + 36 + (114 - $$6) / 2, 34, -16777216, false);
        int $$7 = this.font.width(this.ownerText);
        p_422561_.drawString(this.font, this.ownerText, $$4 + 36 + (114 - $$7) / 2, 60, -16777216, false);
        p_422561_.drawWordWrap(this.font, FINALIZE_WARNING_LABEL, $$4 + 36, 82, 114, -16777216, false);
    }

    @Override
    public void renderBackground(GuiGraphics p_421786_, int p_422251_, int p_421978_, float p_421611_) {
        this.renderTransparentBackground(p_421786_);
        p_421786_.blit(RenderPipelines.GUI_TEXTURED, BookViewScreen.BOOK_LOCATION, (this.width - 192) / 2, 2, 0.0f, 0.0f, 192, 192, 256, 256);
    }
}

