/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.BaseCommandBlock;

public abstract class AbstractCommandBlockEditScreen
extends Screen {
    private static final Component SET_COMMAND_LABEL = Component.translatable("advMode.setCommand");
    private static final Component COMMAND_LABEL = Component.translatable("advMode.command");
    private static final Component PREVIOUS_OUTPUT_LABEL = Component.translatable("advMode.previousOutput");
    protected EditBox commandEdit;
    protected EditBox previousEdit;
    protected Button doneButton;
    protected Button cancelButton;
    protected CycleButton<Boolean> outputButton;
    CommandSuggestions commandSuggestions;

    public AbstractCommandBlockEditScreen() {
        super(GameNarrator.NO_TITLE);
    }

    @Override
    public void tick() {
        if (!this.getCommandBlock().isValid()) {
            this.onClose();
        }
    }

    abstract BaseCommandBlock getCommandBlock();

    abstract int getPreviousY();

    @Override
    protected void init() {
        this.doneButton = this.addRenderableWidget(Button.builder(CommonComponents.GUI_DONE, p_97691_ -> this.onDone()).bounds(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20).build());
        this.cancelButton = this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_425144_ -> this.onClose()).bounds(this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20).build());
        boolean $$0 = this.getCommandBlock().isTrackOutput();
        this.outputButton = this.addRenderableWidget(CycleButton.booleanBuilder(Component.literal("O"), Component.literal("X")).withInitialValue($$0).displayOnlyValue().create(this.width / 2 + 150 - 20, this.getPreviousY(), 20, 20, Component.translatable("advMode.trackOutput"), (p_169596_, p_169597_) -> {
            BaseCommandBlock $$2 = this.getCommandBlock();
            $$2.setTrackOutput((boolean)p_169597_);
            this.updatePreviousOutput((boolean)p_169597_);
        }));
        this.commandEdit = new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)Component.translatable("advMode.command")){

            @Override
            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(AbstractCommandBlockEditScreen.this.commandSuggestions.getNarrationMessage());
            }
        };
        this.commandEdit.setMaxLength(32500);
        this.commandEdit.setResponder(this::onEdited);
        this.addWidget(this.commandEdit);
        this.previousEdit = new EditBox(this.font, this.width / 2 - 150, this.getPreviousY(), 276, 20, Component.translatable("advMode.previousOutput"));
        this.previousEdit.setMaxLength(32500);
        this.previousEdit.setEditable(false);
        this.previousEdit.setValue("-");
        this.addWidget(this.previousEdit);
        this.commandSuggestions = new CommandSuggestions(this.minecraft, this, this.commandEdit, this.font, true, true, 0, 7, false, Integer.MIN_VALUE);
        this.commandSuggestions.setAllowSuggestions(true);
        this.commandSuggestions.updateCommandInfo();
        this.updatePreviousOutput($$0);
    }

    @Override
    protected void setInitialFocus() {
        this.setInitialFocus(this.commandEdit);
    }

    @Override
    protected Component getUsageNarration() {
        if (this.commandSuggestions.isVisible()) {
            return this.commandSuggestions.getUsageNarration();
        }
        return super.getUsageNarration();
    }

    @Override
    public void resize(Minecraft p_97677_, int p_97678_, int p_97679_) {
        String $$3 = this.commandEdit.getValue();
        this.init(p_97677_, p_97678_, p_97679_);
        this.commandEdit.setValue($$3);
        this.commandSuggestions.updateCommandInfo();
    }

    protected void updatePreviousOutput(boolean p_169599_) {
        this.previousEdit.setValue(p_169599_ ? this.getCommandBlock().getLastOutput().getString() : "-");
    }

    protected void onDone() {
        BaseCommandBlock $$0 = this.getCommandBlock();
        this.populateAndSendPacket($$0);
        if (!$$0.isTrackOutput()) {
            $$0.setLastOutput(null);
        }
        this.minecraft.setScreen(null);
    }

    protected abstract void populateAndSendPacket(BaseCommandBlock var1);

    private void onEdited(String p_97689_) {
        this.commandSuggestions.updateCommandInfo();
    }

    @Override
    public boolean keyPressed(int p_97667_, int p_97668_, int p_97669_) {
        if (this.commandSuggestions.keyPressed(p_97667_, p_97668_, p_97669_)) {
            return true;
        }
        if (super.keyPressed(p_97667_, p_97668_, p_97669_)) {
            return true;
        }
        if (p_97667_ == 257 || p_97667_ == 335) {
            this.onDone();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double p_97659_, double p_97660_, double p_97661_, double p_294594_) {
        if (this.commandSuggestions.mouseScrolled(p_294594_)) {
            return true;
        }
        return super.mouseScrolled(p_97659_, p_97660_, p_97661_, p_294594_);
    }

    @Override
    public boolean mouseClicked(double p_97663_, double p_97664_, int p_97665_) {
        if (this.commandSuggestions.mouseClicked(p_97663_, p_97664_, p_97665_)) {
            return true;
        }
        return super.mouseClicked(p_97663_, p_97664_, p_97665_);
    }

    @Override
    public void render(GuiGraphics p_283074_, int p_97673_, int p_97674_, float p_97675_) {
        super.render(p_283074_, p_97673_, p_97674_, p_97675_);
        p_283074_.drawCenteredString(this.font, SET_COMMAND_LABEL, this.width / 2, 20, -1);
        p_283074_.drawString(this.font, COMMAND_LABEL, this.width / 2 - 150 + 1, 40, -6250336);
        this.commandEdit.render(p_283074_, p_97673_, p_97674_, p_97675_);
        int $$4 = 75;
        if (!this.previousEdit.getValue().isEmpty()) {
            p_283074_.drawString(this.font, PREVIOUS_OUTPUT_LABEL, this.width / 2 - 150 + 1, ($$4 += 5 * this.font.lineHeight + 1 + this.getPreviousY() - 135) + 4, -6250336);
            this.previousEdit.render(p_283074_, p_97673_, p_97674_, p_97675_);
        }
        this.commandSuggestions.render(p_283074_, p_97673_, p_97674_);
    }

    @Override
    public void renderBackground(GuiGraphics p_333760_, int p_333752_, int p_333931_, float p_333774_) {
        this.renderTransparentBackground(p_333760_);
    }
}

