/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.dialog;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ScrollableLayout;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.dialog.DialogConnectionAccess;
import net.minecraft.client.gui.screens.dialog.DialogControlSet;
import net.minecraft.client.gui.screens.dialog.WaitingForResponseScreen;
import net.minecraft.client.gui.screens.dialog.body.DialogBodyHandlers;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogAction;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.body.DialogBody;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class DialogScreen<T extends Dialog>
extends Screen {
    public static final Component DISCONNECT = Component.translatable("menu.custom_screen_info.disconnect");
    private static final int WARNING_BUTTON_SIZE = 20;
    private static final WidgetSprites WARNING_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("dialog/warning_button"), ResourceLocation.withDefaultNamespace("dialog/warning_button_disabled"), ResourceLocation.withDefaultNamespace("dialog/warning_button_highlighted"));
    private final T dialog;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    @Nullable
    private final Screen previousScreen;
    @Nullable
    private ScrollableLayout bodyScroll;
    private Button warningButton;
    private final DialogConnectionAccess connectionAccess;
    private Supplier<Optional<ClickEvent>> onClose = DialogControlSet.EMPTY_ACTION;

    public DialogScreen(@Nullable Screen p_425924_, T p_426171_, DialogConnectionAccess p_427372_) {
        super(p_426171_.common().title());
        this.dialog = p_426171_;
        this.previousScreen = p_425924_;
        this.connectionAccess = p_427372_;
    }

    @Override
    protected final void init() {
        super.init();
        this.warningButton = this.createWarningButton();
        this.warningButton.setTabOrderGroup(-10);
        DialogControlSet $$0 = new DialogControlSet(this);
        LinearLayout $$1 = LinearLayout.vertical().spacing(10);
        $$1.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addToHeader(this.createTitleWithWarningButton());
        for (DialogBody $$2 : this.dialog.common().body()) {
            LayoutElement $$3 = DialogBodyHandlers.createBodyElement(this, $$2);
            if ($$3 == null) continue;
            $$1.addChild($$3);
        }
        for (Input $$4 : this.dialog.common().inputs()) {
            $$0.addInput($$4, $$1::addChild);
        }
        this.populateBodyElements($$1, $$0, this.dialog, this.connectionAccess);
        this.bodyScroll = new ScrollableLayout(this.minecraft, $$1, this.layout.getContentHeight());
        this.layout.addToContents(this.bodyScroll);
        this.updateHeaderAndFooter(this.layout, $$0, this.dialog, this.connectionAccess);
        this.onClose = $$0.bindAction(this.dialog.onCancel());
        this.layout.visitWidgets(p_425641_ -> {
            if (p_425641_ != this.warningButton) {
                this.addRenderableWidget(p_425641_);
            }
        });
        this.addRenderableWidget(this.warningButton);
        this.repositionElements();
    }

    protected void populateBodyElements(LinearLayout p_425540_, DialogControlSet p_428409_, T p_426230_, DialogConnectionAccess p_427345_) {
    }

    protected void updateHeaderAndFooter(HeaderAndFooterLayout p_425628_, DialogControlSet p_428522_, T p_425752_, DialogConnectionAccess p_427506_) {
    }

    @Override
    protected void repositionElements() {
        this.bodyScroll.setMaxHeight(this.layout.getContentHeight());
        this.layout.arrangeElements();
        this.makeSureWarningButtonIsInBounds();
    }

    protected LayoutElement createTitleWithWarningButton() {
        LinearLayout $$0 = LinearLayout.horizontal().spacing(10);
        $$0.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle();
        $$0.addChild(new StringWidget(this.title, this.font));
        $$0.addChild(this.warningButton);
        return $$0;
    }

    protected void makeSureWarningButtonIsInBounds() {
        int $$0 = this.warningButton.getX();
        int $$1 = this.warningButton.getY();
        if ($$0 < 0 || $$1 < 0 || $$0 > this.width - 20 || $$1 > this.height - 20) {
            this.warningButton.setX(Math.max(0, this.width - 40));
            this.warningButton.setY(Math.min(5, this.height));
        }
    }

    private Button createWarningButton() {
        ImageButton $$0 = new ImageButton(0, 0, 20, 20, WARNING_BUTTON_SPRITES, p_428749_ -> this.minecraft.setScreen(WarningScreen.create(this.minecraft, this)), Component.translatable("menu.custom_screen_info.button_narration"));
        $$0.setTooltip(Tooltip.create(Component.translatable("menu.custom_screen_info.tooltip")));
        return $$0;
    }

    @Override
    public boolean isPauseScreen() {
        return this.dialog.common().pause();
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return this.dialog.common().canCloseWithEscape();
    }

    @Override
    public void onClose() {
        this.runAction(this.onClose.get(), DialogAction.CLOSE);
    }

    public void runAction(Optional<ClickEvent> p_428264_) {
        this.runAction(p_428264_, this.dialog.common().afterAction());
    }

    public void runAction(Optional<ClickEvent> p_428216_, DialogAction p_428273_) {
        Screen $$2;
        switch (p_428273_) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                Screen screen = this;
                break;
            }
            case CLOSE: {
                Screen screen = this.previousScreen;
                break;
            }
            case WAIT_FOR_RESPONSE: {
                Screen screen = $$2 = new WaitingForResponseScreen(this.previousScreen);
            }
        }
        if (p_428216_.isPresent()) {
            this.handleDialogClickEvent(p_428216_.get(), $$2);
        } else {
            this.minecraft.setScreen($$2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDialogClickEvent(ClickEvent p_427388_, @Nullable Screen p_428550_) {
        ClickEvent clickEvent = p_427388_;
        Objects.requireNonNull(clickEvent);
        ClickEvent clickEvent2 = clickEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.RunCommand.class, ClickEvent.ShowDialog.class, ClickEvent.Custom.class}, (Object)clickEvent2, n)) {
            case 0: {
                ClickEvent.RunCommand runCommand = (ClickEvent.RunCommand)clickEvent2;
                try {
                    String string;
                    String $$2 = string = runCommand.command();
                    this.connectionAccess.runCommand(Commands.trimOptionalPrefix($$2), p_428550_);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                ClickEvent.ShowDialog $$3 = (ClickEvent.ShowDialog)clickEvent2;
                this.connectionAccess.openDialog($$3.dialog(), p_428550_);
                return;
            }
            case 2: {
                ClickEvent.Custom $$4 = (ClickEvent.Custom)clickEvent2;
                this.connectionAccess.sendCustomAction($$4.id(), $$4.payload());
                this.minecraft.setScreen(p_428550_);
                return;
            }
        }
        DialogScreen.defaultHandleClickEvent(p_427388_, this.minecraft, p_428550_);
    }

    @Nullable
    public Screen previousScreen() {
        return this.previousScreen;
    }

    protected static LayoutElement packControlsIntoColumns(List<? extends LayoutElement> p_425683_, int p_425923_) {
        GridLayout $$2 = new GridLayout();
        $$2.defaultCellSetting().alignHorizontallyCenter();
        $$2.columnSpacing(2).rowSpacing(2);
        int $$3 = p_425683_.size();
        int $$4 = $$3 / p_425923_;
        int $$5 = $$4 * p_425923_;
        for (int $$6 = 0; $$6 < $$5; ++$$6) {
            $$2.addChild(p_425683_.get($$6), $$6 / p_425923_, $$6 % p_425923_);
        }
        if ($$3 != $$5) {
            LinearLayout $$7 = LinearLayout.horizontal().spacing(2);
            $$7.defaultCellSetting().alignHorizontallyCenter();
            for (int $$8 = $$5; $$8 < $$3; ++$$8) {
                $$7.addChild(p_425683_.get($$8));
            }
            $$2.addChild($$7, $$4, 0, 1, p_425923_);
        }
        return $$2;
    }

    public static class WarningScreen
    extends ConfirmScreen {
        private final MutableObject<Screen> returnScreen;

        public static Screen create(Minecraft p_427253_, Screen p_428764_) {
            return new WarningScreen(p_427253_, (MutableObject<Screen>)new MutableObject((Object)p_428764_));
        }

        private WarningScreen(Minecraft p_427476_, MutableObject<Screen> p_427235_) {
            super(p_428065_ -> {
                if (p_428065_) {
                    PauseScreen.disconnectFromWorld(p_427476_, DISCONNECT);
                } else {
                    p_427476_.setScreen((Screen)p_427235_.getValue());
                }
            }, Component.translatable("menu.custom_screen_info.title"), Component.translatable("menu.custom_screen_info.contents"), CommonComponents.disconnectButtonLabel(p_427476_.isLocalServer()), CommonComponents.GUI_BACK);
            this.returnScreen = p_427235_;
        }

        @Nullable
        public Screen returnScreen() {
            return (Screen)this.returnScreen.getValue();
        }

        public void updateReturnScreen(@Nullable Screen p_428767_) {
            this.returnScreen.setValue((Object)p_428767_);
        }
    }
}

