/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.realmsclient.RealmsMainScreen;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.NowPlayingToast;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.Dialogs;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DialogTags;
import net.minecraft.util.CommonLinks;

public class PauseScreen
extends Screen {
    private static final ResourceLocation DRAFT_REPORT_SPRITE = ResourceLocation.withDefaultNamespace("icon/draft_report");
    private static final int COLUMNS = 2;
    private static final int MENU_PADDING_TOP = 50;
    private static final int BUTTON_PADDING = 4;
    private static final int BUTTON_WIDTH_FULL = 204;
    private static final int BUTTON_WIDTH_HALF = 98;
    private static final Component RETURN_TO_GAME = Component.translatable("menu.returnToGame");
    private static final Component ADVANCEMENTS = Component.translatable("gui.advancements");
    private static final Component STATS = Component.translatable("gui.stats");
    private static final Component SEND_FEEDBACK = Component.translatable("menu.sendFeedback");
    private static final Component REPORT_BUGS = Component.translatable("menu.reportBugs");
    private static final Component FEEDBACK_SUBSCREEN = Component.translatable("menu.feedback");
    private static final Component OPTIONS = Component.translatable("menu.options");
    private static final Component SHARE_TO_LAN = Component.translatable("menu.shareToLan");
    private static final Component PLAYER_REPORTING = Component.translatable("menu.playerReporting");
    private static final Component GAME = Component.translatable("menu.game");
    private static final Component PAUSED = Component.translatable("menu.paused");
    private static final Tooltip CUSTOM_OPTIONS_TOOLTIP = Tooltip.create(Component.translatable("menu.custom_options.tooltip"));
    private final boolean showPauseMenu;
    @Nullable
    private Button disconnectButton;

    public PauseScreen(boolean p_96308_) {
        super(p_96308_ ? GAME : PAUSED);
        this.showPauseMenu = p_96308_;
    }

    public boolean showsPauseMenu() {
        return this.showPauseMenu;
    }

    @Override
    protected void init() {
        if (this.showPauseMenu) {
            this.createPauseMenu();
        }
        this.addRenderableWidget(new StringWidget(0, this.showPauseMenu ? 40 : 10, this.width, this.font.lineHeight, this.title, this.font));
    }

    private void createPauseMenu() {
        GridLayout $$0 = new GridLayout();
        $$0.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper $$1 = $$0.createRowHelper(2);
        $$1.addChild(Button.builder(RETURN_TO_GAME, p_280814_ -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }).width(204).build(), 2, $$0.newCellSettings().paddingTop(50));
        $$1.addChild(this.openScreenButton(ADVANCEMENTS, () -> new AdvancementsScreen(this.minecraft.player.connection.getAdvancements(), this)));
        $$1.addChild(this.openScreenButton(STATS, () -> new StatsScreen(this, this.minecraft.player.getStats())));
        Optional<? extends Holder<Dialog>> $$2 = this.getCustomAdditions();
        if ($$2.isEmpty()) {
            PauseScreen.addFeedbackButtons(this, $$1);
        } else {
            this.addFeedbackSubscreenAndCustomDialogButtons(this.minecraft, $$2.get(), $$1);
        }
        $$1.addChild(this.openScreenButton(OPTIONS, () -> new OptionsScreen(this, this.minecraft.options)));
        if (this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished()) {
            $$1.addChild(this.openScreenButton(SHARE_TO_LAN, () -> new ShareToLanScreen(this)));
        } else {
            $$1.addChild(this.openScreenButton(PLAYER_REPORTING, () -> new SocialInteractionsScreen(this)));
        }
        this.disconnectButton = $$1.addChild(Button.builder(CommonComponents.disconnectButtonLabel(this.minecraft.isLocalServer()), p_280815_ -> {
            p_280815_.active = false;
            this.minecraft.getReportingContext().draftReportHandled(this.minecraft, this, () -> PauseScreen.disconnectFromWorld(this.minecraft, ClientLevel.DEFAULT_QUIT_MESSAGE), true);
        }).width(204).build(), 2);
        $$0.arrangeElements();
        FrameLayout.alignInRectangle($$0, 0, 0, this.width, this.height, 0.5f, 0.25f);
        $$0.visitWidgets(this::addRenderableWidget);
    }

    private Optional<? extends Holder<Dialog>> getCustomAdditions() {
        HolderSet $$2;
        HolderLookup.RegistryLookup $$0 = this.minecraft.player.connection.registryAccess().lookupOrThrow(Registries.DIALOG);
        Optional $$1 = $$0.get(DialogTags.PAUSE_SCREEN_ADDITIONS);
        if ($$1.isPresent() && ($$2 = (HolderSet)$$1.get()).size() > 0) {
            if ($$2.size() == 1) {
                return Optional.of($$2.get(0));
            }
            return $$0.get(Dialogs.CUSTOM_OPTIONS);
        }
        ServerLinks $$3 = this.minecraft.player.connection.serverLinks();
        if (!$$3.isEmpty()) {
            return $$0.get(Dialogs.SERVER_LINKS);
        }
        return Optional.empty();
    }

    static void addFeedbackButtons(Screen p_350532_, GridLayout.RowHelper p_351050_) {
        p_351050_.addChild(PauseScreen.openLinkButton(p_350532_, SEND_FEEDBACK, SharedConstants.getCurrentVersion().stable() ? CommonLinks.RELEASE_FEEDBACK : CommonLinks.SNAPSHOT_FEEDBACK));
        p_351050_.addChild(PauseScreen.openLinkButton((Screen)p_350532_, (Component)PauseScreen.REPORT_BUGS, (URI)CommonLinks.SNAPSHOT_BUGS_FEEDBACK)).active = !SharedConstants.getCurrentVersion().dataVersion().isSideSeries();
    }

    private void addFeedbackSubscreenAndCustomDialogButtons(Minecraft p_426328_, Holder<Dialog> p_425750_, GridLayout.RowHelper p_426019_) {
        p_426019_.addChild(this.openScreenButton(FEEDBACK_SUBSCREEN, () -> new FeedbackSubScreen(this)));
        p_426019_.addChild(Button.builder(p_425750_.value().common().computeExternalTitle(), p_428054_ -> p_428052_.player.connection.showDialog(p_425750_, this)).width(98).tooltip(CUSTOM_OPTIONS_TOOLTIP).build());
    }

    public static void disconnectFromWorld(Minecraft p_428236_, Component p_428192_) {
        boolean $$2 = p_428236_.isLocalServer();
        ServerData $$3 = p_428236_.getCurrentServer();
        if (p_428236_.level != null) {
            p_428236_.level.disconnect(p_428192_);
        }
        if ($$2) {
            p_428236_.disconnectWithSavingScreen();
        } else {
            p_428236_.disconnectWithProgressScreen();
        }
        TitleScreen $$4 = new TitleScreen();
        if ($$2) {
            p_428236_.setScreen($$4);
        } else if ($$3 != null && $$3.isRealm()) {
            p_428236_.setScreen(new RealmsMainScreen($$4));
        } else {
            p_428236_.setScreen(new JoinMultiplayerScreen($$4));
        }
    }

    @Override
    public void tick() {
        if (this.rendersNowPlayingToast()) {
            NowPlayingToast.tickMusicNotes();
        }
    }

    @Override
    public void render(GuiGraphics p_281899_, int p_281431_, int p_283183_, float p_281435_) {
        super.render(p_281899_, p_281431_, p_283183_, p_281435_);
        if (this.rendersNowPlayingToast()) {
            NowPlayingToast.renderToast(p_281899_, this.font);
        }
        if (this.showPauseMenu && this.minecraft != null && this.minecraft.getReportingContext().hasDraftReport() && this.disconnectButton != null) {
            p_281899_.blitSprite(RenderPipelines.GUI_TEXTURED, DRAFT_REPORT_SPRITE, this.disconnectButton.getX() + this.disconnectButton.getWidth() - 17, this.disconnectButton.getY() + 3, 15, 15);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_295883_, int p_294974_, int p_295209_, float p_295290_) {
        if (this.showPauseMenu) {
            super.renderBackground(p_295883_, p_294974_, p_295209_, p_295290_);
        }
    }

    public boolean rendersNowPlayingToast() {
        Options $$0 = this.minecraft.options;
        return $$0.showNowPlayingToast().get() != false && $$0.getFinalSoundSourceVolume(SoundSource.MUSIC) > 0.0f && this.showPauseMenu;
    }

    private Button openScreenButton(Component p_262567_, Supplier<Screen> p_262581_) {
        return Button.builder(p_262567_, p_280817_ -> this.minecraft.setScreen((Screen)p_262581_.get())).width(98).build();
    }

    private static Button openLinkButton(Screen p_350313_, Component p_262593_, URI p_352111_) {
        return Button.builder(p_262593_, ConfirmLinkScreen.confirmLink(p_350313_, p_352111_)).width(98).build();
    }

    static class FeedbackSubScreen
    extends Screen {
        private static final Component TITLE = Component.translatable("menu.feedback.title");
        public final Screen parent;
        private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);

        protected FeedbackSubScreen(Screen p_350989_) {
            super(TITLE);
            this.parent = p_350989_;
        }

        @Override
        protected void init() {
            this.layout.addTitleHeader(TITLE, this.font);
            GridLayout $$0 = this.layout.addToContents(new GridLayout());
            $$0.defaultCellSetting().padding(4, 4, 4, 0);
            GridLayout.RowHelper $$1 = $$0.createRowHelper(2);
            PauseScreen.addFeedbackButtons(this, $$1);
            this.layout.addToFooter(Button.builder(CommonComponents.GUI_BACK, p_350752_ -> this.onClose()).width(200).build());
            this.layout.visitWidgets(this::addRenderableWidget);
            this.repositionElements();
        }

        @Override
        protected void repositionElements() {
            this.layout.arrangeElements();
        }

        @Override
        public void onClose() {
            this.minecraft.setScreen(this.parent);
        }
    }
}

