/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;

public class CreateFlatWorldScreen
extends Screen {
    private static final Component TITLE = Component.translatable("createWorld.customize.flat.title");
    static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot");
    private static final int SLOT_BG_SIZE = 18;
    private static final int SLOT_STAT_HEIGHT = 20;
    private static final int SLOT_BG_X = 1;
    private static final int SLOT_BG_Y = 1;
    private static final int SLOT_FG_X = 2;
    private static final int SLOT_FG_Y = 2;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this, 33, 64);
    protected final CreateWorldScreen parent;
    private final Consumer<FlatLevelGeneratorSettings> applySettings;
    FlatLevelGeneratorSettings generator;
    @Nullable
    private DetailsList list;
    @Nullable
    private Button deleteLayerButton;

    public CreateFlatWorldScreen(CreateWorldScreen p_95822_, Consumer<FlatLevelGeneratorSettings> p_95823_, FlatLevelGeneratorSettings p_95824_) {
        super(TITLE);
        this.parent = p_95822_;
        this.applySettings = p_95823_;
        this.generator = p_95824_;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.generator;
    }

    public void setConfig(FlatLevelGeneratorSettings p_95826_) {
        this.generator = p_95826_;
        if (this.list != null) {
            this.list.resetRows();
            this.updateButtonValidity();
        }
    }

    @Override
    protected void init() {
        this.layout.addTitleHeader(this.title, this.font);
        this.list = this.layout.addToContents(new DetailsList());
        LinearLayout $$0 = this.layout.addToFooter(LinearLayout.vertical().spacing(4));
        $$0.defaultCellSetting().alignVerticallyMiddle();
        LinearLayout $$1 = $$0.addChild(LinearLayout.horizontal().spacing(8));
        LinearLayout $$2 = $$0.addChild(LinearLayout.horizontal().spacing(8));
        this.deleteLayerButton = $$1.addChild(Button.builder(Component.translatable("createWorld.customize.flat.removeLayer"), p_95845_ -> {
            if (!this.hasValidSelection()) {
                return;
            }
            List<FlatLayerInfo> $$1 = this.generator.getLayersInfo();
            int $$2 = this.list.children().indexOf(this.list.getSelected());
            int $$3 = $$1.size() - $$2 - 1;
            $$1.remove($$3);
            this.list.setSelected($$1.isEmpty() ? null : (DetailsList.Entry)this.list.children().get(Math.min($$2, $$1.size() - 1)));
            this.generator.updateLayers();
            this.list.resetRows();
            this.updateButtonValidity();
        }).build());
        $$1.addChild(Button.builder(Component.translatable("createWorld.customize.presets"), p_280790_ -> {
            this.minecraft.setScreen(new PresetFlatWorldScreen(this));
            this.generator.updateLayers();
            this.updateButtonValidity();
        }).build());
        $$2.addChild(Button.builder(CommonComponents.GUI_DONE, p_382516_ -> {
            this.applySettings.accept(this.generator);
            this.onClose();
            this.generator.updateLayers();
        }).build());
        $$2.addChild(Button.builder(CommonComponents.GUI_CANCEL, p_382515_ -> {
            this.onClose();
            this.generator.updateLayers();
        }).build());
        this.generator.updateLayers();
        this.updateButtonValidity();
        this.layout.visitWidgets(this::addRenderableWidget);
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
        this.layout.arrangeElements();
    }

    void updateButtonValidity() {
        if (this.deleteLayerButton != null) {
            this.deleteLayerButton.active = this.hasValidSelection();
        }
    }

    private boolean hasValidSelection() {
        return this.list != null && this.list.getSelected() != null;
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    class DetailsList
    extends ObjectSelectionList<Entry> {
        private static final Component LAYER_MATERIAL_TITLE = Component.translatable("createWorld.customize.flat.tile").withStyle(ChatFormatting.UNDERLINE);
        private static final Component HEIGHT_TITLE = Component.translatable("createWorld.customize.flat.height").withStyle(ChatFormatting.UNDERLINE);

        public DetailsList() {
            super(CreateFlatWorldScreen.this.minecraft, CreateFlatWorldScreen.this.width, CreateFlatWorldScreen.this.height - 103, 43, 24, (int)((double)CreateFlatWorldScreen.this.font.lineHeight * 1.5));
            for (int $$0 = 0; $$0 < CreateFlatWorldScreen.this.generator.getLayersInfo().size(); ++$$0) {
                this.addEntry(new Entry());
            }
        }

        @Override
        public void setSelected(@Nullable Entry p_95855_) {
            super.setSelected(p_95855_);
            CreateFlatWorldScreen.this.updateButtonValidity();
        }

        public void resetRows() {
            int $$0 = this.children().indexOf(this.getSelected());
            this.clearEntries();
            for (int $$1 = 0; $$1 < CreateFlatWorldScreen.this.generator.getLayersInfo().size(); ++$$1) {
                this.addEntry(new Entry());
            }
            List $$2 = this.children();
            if ($$0 >= 0 && $$0 < $$2.size()) {
                this.setSelected((Entry)$$2.get($$0));
            }
        }

        @Override
        protected void renderHeader(GuiGraphics p_383037_, int p_383194_, int p_383114_) {
            p_383037_.drawString(CreateFlatWorldScreen.this.font, LAYER_MATERIAL_TITLE, p_383194_, p_383114_, -1);
            p_383037_.drawString(CreateFlatWorldScreen.this.font, HEIGHT_TITLE, p_383194_ + this.getRowWidth() - CreateFlatWorldScreen.this.font.width(HEIGHT_TITLE) - 8, p_383114_, -1);
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            Entry() {
            }

            @Override
            public void render(GuiGraphics p_281319_, int p_281943_, int p_283629_, int p_283315_, int p_282974_, int p_281870_, int p_283341_, int p_281639_, boolean p_282715_, float p_281937_) {
                MutableComponent $$16;
                FlatLayerInfo $$10 = CreateFlatWorldScreen.this.generator.getLayersInfo().get(CreateFlatWorldScreen.this.generator.getLayersInfo().size() - p_281943_ - 1);
                BlockState $$11 = $$10.getBlockState();
                ItemStack $$12 = this.getDisplayItem($$11);
                this.blitSlot(p_281319_, p_283315_, p_283629_, $$12);
                int $$13 = p_283629_ + p_281870_ / 2 - CreateFlatWorldScreen.this.font.lineHeight / 2;
                p_281319_.drawString(CreateFlatWorldScreen.this.font, $$12.getHoverName(), p_283315_ + 18 + 5, $$13, -1);
                if (p_281943_ == 0) {
                    MutableComponent $$14 = Component.translatable("createWorld.customize.flat.layer.top", $$10.getHeight());
                } else if (p_281943_ == CreateFlatWorldScreen.this.generator.getLayersInfo().size() - 1) {
                    MutableComponent $$15 = Component.translatable("createWorld.customize.flat.layer.bottom", $$10.getHeight());
                } else {
                    $$16 = Component.translatable("createWorld.customize.flat.layer", $$10.getHeight());
                }
                p_281319_.drawString(CreateFlatWorldScreen.this.font, $$16, p_283315_ + p_282974_ - CreateFlatWorldScreen.this.font.width($$16) - 8, $$13, -1);
            }

            private ItemStack getDisplayItem(BlockState p_169294_) {
                Item $$1 = p_169294_.getBlock().asItem();
                if ($$1 == Items.AIR) {
                    if (p_169294_.is(Blocks.WATER)) {
                        $$1 = Items.WATER_BUCKET;
                    } else if (p_169294_.is(Blocks.LAVA)) {
                        $$1 = Items.LAVA_BUCKET;
                    }
                }
                return new ItemStack($$1);
            }

            @Override
            public Component getNarration() {
                FlatLayerInfo $$0 = CreateFlatWorldScreen.this.generator.getLayersInfo().get(CreateFlatWorldScreen.this.generator.getLayersInfo().size() - DetailsList.this.children().indexOf(this) - 1);
                ItemStack $$1 = this.getDisplayItem($$0.getBlockState());
                if (!$$1.isEmpty()) {
                    return Component.translatable("narrator.select", $$1.getHoverName());
                }
                return CommonComponents.EMPTY;
            }

            @Override
            public boolean mouseClicked(double p_95868_, double p_95869_, int p_95870_) {
                DetailsList.this.setSelected(this);
                return super.mouseClicked(p_95868_, p_95869_, p_95870_);
            }

            private void blitSlot(GuiGraphics p_281733_, int p_282373_, int p_282844_, ItemStack p_281263_) {
                this.blitSlotBg(p_281733_, p_282373_ + 1, p_282844_ + 1);
                if (!p_281263_.isEmpty()) {
                    p_281733_.renderFakeItem(p_281263_, p_282373_ + 2, p_282844_ + 2);
                }
            }

            private void blitSlotBg(GuiGraphics p_282271_, int p_281324_, int p_283171_) {
                p_282271_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_SPRITE, p_281324_, p_283171_, 18, 18);
            }
        }
    }
}

