/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.TransferState;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.client.quickplay.QuickPlay;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.client.resources.server.ServerPackManager;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import org.slf4j.Logger;

public class ConnectScreen
extends Screen {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final long NARRATION_DELAY_MS = 2000L;
    public static final Component ABORT_CONNECTION = Component.translatable("connect.aborted");
    public static final Component UNKNOWN_HOST_MESSAGE = Component.translatable("disconnect.genericReason", Component.translatable("disconnect.unknownHost"));
    @Nullable
    volatile Connection connection;
    @Nullable
    ChannelFuture channelFuture;
    volatile boolean aborted;
    final Screen parent;
    private Component status = Component.translatable("connect.connecting");
    private long lastNarration = -1L;
    final Component connectFailedTitle;

    private ConnectScreen(Screen p_279215_, Component p_279228_) {
        super(GameNarrator.NO_TITLE);
        this.parent = p_279215_;
        this.connectFailedTitle = p_279228_;
    }

    public static void startConnecting(Screen p_279473_, Minecraft p_279200_, ServerAddress p_279150_, ServerData p_279481_, boolean p_279117_, @Nullable TransferState p_320013_) {
        Component $$8;
        if (p_279200_.screen instanceof ConnectScreen) {
            LOGGER.error("Attempt to connect while already connecting");
            return;
        }
        if (p_320013_ != null) {
            Component $$6 = CommonComponents.TRANSFER_CONNECT_FAILED;
        } else if (p_279117_) {
            Component $$7 = QuickPlay.ERROR_TITLE;
        } else {
            $$8 = CommonComponents.CONNECT_FAILED;
        }
        ConnectScreen $$9 = new ConnectScreen(p_279473_, $$8);
        if (p_320013_ != null) {
            $$9.updateStatus(Component.translatable("connect.transferring"));
        }
        p_279200_.disconnectWithProgressScreen();
        p_279200_.prepareForMultiplayer();
        p_279200_.updateReportEnvironment(ReportEnvironment.thirdParty(p_279481_.ip));
        p_279200_.quickPlayLog().setWorldData(QuickPlayLog.Type.MULTIPLAYER, p_279481_.ip, p_279481_.name);
        p_279200_.setScreen($$9);
        $$9.connect(p_279200_, p_279150_, p_279481_, p_320013_);
    }

    private void connect(final Minecraft p_251955_, final ServerAddress p_249536_, final ServerData p_252078_, final @Nullable TransferState p_320415_) {
        LOGGER.info("Connecting to {}, {}", (Object)p_249536_.getHost(), (Object)p_249536_.getPort());
        Thread $$4 = new Thread("Server Connector #" + UNIQUE_THREAD_ID.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void run() {
                InetSocketAddress $$0 = null;
                try {
                    if (ConnectScreen.this.aborted) {
                        return;
                    }
                    Optional<InetSocketAddress> $$1 = ServerNameResolver.DEFAULT.resolveAddress(p_249536_).map(ResolvedServerAddress::asInetSocketAddress);
                    if (ConnectScreen.this.aborted) {
                        return;
                    }
                    if ($$1.isEmpty()) {
                        p_251955_.execute(() -> p_251955_.setScreen(new DisconnectedScreen(ConnectScreen.this.parent, ConnectScreen.this.connectFailedTitle, UNKNOWN_HOST_MESSAGE)));
                        return;
                    }
                    $$0 = $$1.get();
                    ConnectScreen connectScreen = ConnectScreen.this;
                    synchronized (connectScreen) {
                        if (ConnectScreen.this.aborted) {
                            return;
                        }
                        Connection $$2 = new Connection(PacketFlow.CLIENTBOUND);
                        $$2.setBandwidthLogger(p_251955_.getDebugOverlay().getBandwidthLogger());
                        ConnectScreen.this.channelFuture = Connection.connect($$0, p_251955_.options.useNativeTransport(), $$2);
                    }
                    ConnectScreen.this.channelFuture.syncUninterruptibly();
                    connectScreen = ConnectScreen.this;
                    synchronized (connectScreen) {
                        void $$3;
                        if (ConnectScreen.this.aborted) {
                            $$3.disconnect(ABORT_CONNECTION);
                            return;
                        }
                        ConnectScreen.this.connection = $$3;
                        p_251955_.getDownloadedPackSource().configureForServerControl((Connection)$$3, 1.convertPackStatus(p_252078_.getResourcePackStatus()));
                    }
                    ConnectScreen.this.connection.initiateServerboundPlayConnection($$0.getHostName(), $$0.getPort(), LoginProtocols.SERVERBOUND, LoginProtocols.CLIENTBOUND, new ClientHandshakePacketListenerImpl(ConnectScreen.this.connection, p_251955_, p_252078_, ConnectScreen.this.parent, false, null, ConnectScreen.this::updateStatus, p_320415_), p_320415_ != null);
                    ConnectScreen.this.connection.send(new ServerboundHelloPacket(p_251955_.getUser().getName(), p_251955_.getUser().getProfileId()));
                }
                catch (Exception $$4) {
                    Exception $$7;
                    if (ConnectScreen.this.aborted) {
                        return;
                    }
                    Throwable throwable = $$4.getCause();
                    if (throwable instanceof Exception) {
                        Exception $$5;
                        Exception $$6 = $$5 = (Exception)throwable;
                    } else {
                        $$7 = $$4;
                    }
                    LOGGER.error("Couldn't connect to server", (Throwable)$$4);
                    String $$8 = $$0 == null ? $$7.getMessage() : $$7.getMessage().replaceAll($$0.getHostName() + ":" + $$0.getPort(), "").replaceAll($$0.toString(), "");
                    p_251955_.execute(() -> p_251955_.setScreen(new DisconnectedScreen(ConnectScreen.this.parent, ConnectScreen.this.connectFailedTitle, Component.translatable("disconnect.genericReason", $$8))));
                }
            }

            private static ServerPackManager.PackPromptStatus convertPackStatus(ServerData.ServerPackStatus p_314423_) {
                return switch (p_314423_) {
                    default -> throw new MatchException(null, null);
                    case ServerData.ServerPackStatus.ENABLED -> ServerPackManager.PackPromptStatus.ALLOWED;
                    case ServerData.ServerPackStatus.DISABLED -> ServerPackManager.PackPromptStatus.DECLINED;
                    case ServerData.ServerPackStatus.PROMPT -> ServerPackManager.PackPromptStatus.PENDING;
                };
            }
        };
        $$4.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        $$4.start();
    }

    private void updateStatus(Component p_95718_) {
        this.status = p_95718_;
    }

    @Override
    public void tick() {
        if (this.connection != null) {
            if (this.connection.isConnected()) {
                this.connection.tick();
            } else {
                this.connection.handleDisconnection();
            }
        }
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected void init() {
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_289624_ -> {
            ConnectScreen connectScreen = this;
            synchronized (connectScreen) {
                this.aborted = true;
                if (this.channelFuture != null) {
                    this.channelFuture.cancel(true);
                    this.channelFuture = null;
                }
                if (this.connection != null) {
                    this.connection.disconnect(ABORT_CONNECTION);
                }
            }
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 100, this.height / 4 + 120 + 12, 200, 20).build());
    }

    @Override
    public void render(GuiGraphics p_283201_, int p_95701_, int p_95702_, float p_95703_) {
        super.render(p_283201_, p_95701_, p_95702_, p_95703_);
        long $$4 = Util.getMillis();
        if ($$4 - this.lastNarration > 2000L) {
            this.lastNarration = $$4;
            this.minecraft.getNarrator().saySystemNow(Component.translatable("narrator.joining"));
        }
        p_283201_.drawCenteredString(this.font, this.status, this.width / 2, this.height / 2 - 50, -1);
    }
}

