/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.render.state.ScreenArea;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import org.apache.commons.lang3.mutable.MutableInt;

public class GuiRenderState {
    private static final int DEBUG_RECTANGLE_COLOR = 0x774444FF;
    private final List<Node> strata = new ArrayList<Node>();
    private int firstStratumAfterBlur = Integer.MAX_VALUE;
    private Node current;
    private final Set<Object> itemModelIdentities = new HashSet<Object>();
    @Nullable
    private ScreenRectangle lastElementBounds;

    public GuiRenderState() {
        this.nextStratum();
    }

    public void nextStratum() {
        this.current = new Node(null);
        this.strata.add(this.current);
    }

    public void blurBeforeThisStratum() {
        if (this.firstStratumAfterBlur != Integer.MAX_VALUE) {
            throw new IllegalStateException("Can only blur once per frame");
        }
        this.firstStratumAfterBlur = this.strata.size() - 1;
    }

    public void up() {
        if (this.current.up == null) {
            this.current.up = new Node(this.current);
        }
        this.current = this.current.up;
    }

    public void down() {
        if (this.current.down == null) {
            this.current.down = new Node(this.current);
        }
        this.current = this.current.down;
    }

    public void submitItem(GuiItemRenderState p_416573_) {
        if (!this.findAppropriateNode(p_416573_)) {
            return;
        }
        this.itemModelIdentities.add(p_416573_.itemStackRenderState().getModelIdentity());
        this.current.submitItem(p_416573_);
        this.sumbitDebugRectangleIfEnabled(p_416573_.bounds());
    }

    public void submitText(GuiTextRenderState p_416631_) {
        if (!this.findAppropriateNode(p_416631_)) {
            return;
        }
        this.current.submitText(p_416631_);
        this.sumbitDebugRectangleIfEnabled(p_416631_.bounds());
    }

    public void submitPicturesInPictureState(PictureInPictureRenderState p_416091_) {
        if (!this.findAppropriateNode(p_416091_)) {
            return;
        }
        this.current.submitPicturesInPictureState(p_416091_);
        this.sumbitDebugRectangleIfEnabled(p_416091_.bounds());
    }

    public void submitGuiElement(GuiElementRenderState p_416144_) {
        if (!this.findAppropriateNode(p_416144_)) {
            return;
        }
        this.current.submitGuiElement(p_416144_);
        this.sumbitDebugRectangleIfEnabled(p_416144_.bounds());
    }

    private void sumbitDebugRectangleIfEnabled(@Nullable ScreenRectangle p_422532_) {
    }

    private boolean findAppropriateNode(ScreenArea p_422644_) {
        ScreenRectangle $$1 = p_422644_.bounds();
        if ($$1 == null) {
            return false;
        }
        if (this.lastElementBounds != null && this.lastElementBounds.encompasses($$1)) {
            this.up();
        } else {
            this.navigateToAboveHighestElementWithIntersectingBounds($$1);
        }
        this.lastElementBounds = $$1;
        return true;
    }

    private void navigateToAboveHighestElementWithIntersectingBounds(ScreenRectangle p_421652_) {
        Node $$1 = this.strata.getLast();
        while ($$1.up != null) {
            $$1 = $$1.up;
        }
        boolean $$2 = false;
        while (!$$2) {
            boolean bl = $$2 = this.hasIntersection(p_421652_, $$1.elementStates) || this.hasIntersection(p_421652_, $$1.itemStates) || this.hasIntersection(p_421652_, $$1.textStates) || this.hasIntersection(p_421652_, $$1.picturesInPictureStates);
            if ($$1.parent == null) break;
            if ($$2) continue;
            $$1 = $$1.parent;
        }
        this.current = $$1;
        if ($$2) {
            this.up();
        }
    }

    private boolean hasIntersection(ScreenRectangle p_422321_, @Nullable List<? extends ScreenArea> p_422715_) {
        if (p_422715_ != null) {
            for (ScreenArea screenArea : p_422715_) {
                ScreenRectangle $$3 = screenArea.bounds();
                if ($$3 == null || !$$3.intersects(p_422321_)) continue;
                return true;
            }
        }
        return false;
    }

    public void submitBlitToCurrentLayer(BlitRenderState p_427445_) {
        this.current.submitGuiElement(p_427445_);
    }

    public void submitGlyphToCurrentLayer(GuiElementRenderState p_427291_) {
        this.current.submitGlyph(p_427291_);
    }

    public Set<Object> getItemModelIdentities() {
        return this.itemModelIdentities;
    }

    public void forEachElement(LayeredElementConsumer p_418470_, TraverseRange p_419645_) {
        MutableInt $$2 = new MutableInt(0);
        this.traverse((Node p_426878_) -> {
            if (p_426878_.elementStates == null && p_426878_.glyphStates == null) {
                return;
            }
            int $$3 = $$2.incrementAndGet();
            if (p_426878_.elementStates != null) {
                for (GuiElementRenderState $$4 : p_426878_.elementStates) {
                    p_418470_.accept($$4, $$3);
                }
            }
            if (p_426878_.glyphStates != null) {
                for (GuiElementRenderState $$5 : p_426878_.glyphStates) {
                    p_418470_.accept($$5, $$3);
                }
            }
        }, p_419645_);
    }

    public void forEachItem(Consumer<GuiItemRenderState> p_418276_) {
        Node $$1 = this.current;
        this.traverse((Node p_418061_) -> {
            if (p_418061_.itemStates != null) {
                this.current = p_418061_;
                for (GuiItemRenderState $$2 : p_418061_.itemStates) {
                    p_418276_.accept($$2);
                }
            }
        }, TraverseRange.ALL);
        this.current = $$1;
    }

    public void forEachText(Consumer<GuiTextRenderState> p_418229_) {
        Node $$1 = this.current;
        this.traverse((Node p_421279_) -> {
            if (p_421279_.textStates != null) {
                for (GuiTextRenderState $$2 : p_421279_.textStates) {
                    this.current = p_421279_;
                    p_418229_.accept($$2);
                }
            }
        }, TraverseRange.ALL);
        this.current = $$1;
    }

    public void forEachPictureInPicture(Consumer<PictureInPictureRenderState> p_418352_) {
        Node $$1 = this.current;
        this.traverse((Node p_418372_) -> {
            if (p_418372_.picturesInPictureStates != null) {
                this.current = p_418372_;
                for (PictureInPictureRenderState $$2 : p_418372_.picturesInPictureStates) {
                    p_418352_.accept($$2);
                }
            }
        }, TraverseRange.ALL);
        this.current = $$1;
    }

    public void sortElements(Comparator<GuiElementRenderState> p_418003_) {
        this.traverse((Node p_418195_) -> {
            if (p_418195_.elementStates != null) {
                p_418195_.elementStates.sort(p_418003_);
            }
        }, TraverseRange.ALL);
    }

    private void traverse(Consumer<Node> p_418051_, TraverseRange p_419641_) {
        int $$2 = 0;
        int $$3 = this.strata.size();
        if (p_419641_ == TraverseRange.BEFORE_BLUR) {
            $$3 = Math.min(this.firstStratumAfterBlur, this.strata.size());
        } else if (p_419641_ == TraverseRange.AFTER_BLUR) {
            $$2 = this.firstStratumAfterBlur;
        }
        for (int $$4 = $$2; $$4 < $$3; ++$$4) {
            Node $$5 = this.strata.get($$4);
            this.traverse($$5, p_418051_);
        }
    }

    private void traverse(Node p_418468_, Consumer<Node> p_418350_) {
        if (p_418468_.down != null) {
            this.traverse(p_418468_.down, p_418350_);
        }
        p_418350_.accept(p_418468_);
        if (p_418468_.up != null) {
            this.traverse(p_418468_.up, p_418350_);
        }
    }

    public void reset() {
        this.itemModelIdentities.clear();
        this.strata.clear();
        this.firstStratumAfterBlur = Integer.MAX_VALUE;
        this.nextStratum();
    }

    static class Node {
        @Nullable
        public final Node parent;
        @Nullable
        public Node up;
        @Nullable
        public Node down;
        @Nullable
        public List<GuiElementRenderState> elementStates;
        @Nullable
        public List<GuiElementRenderState> glyphStates;
        @Nullable
        public List<GuiItemRenderState> itemStates;
        @Nullable
        public List<GuiTextRenderState> textStates;
        @Nullable
        public List<PictureInPictureRenderState> picturesInPictureStates;

        Node(@Nullable Node p_418301_) {
            this.parent = p_418301_;
        }

        public void submitItem(GuiItemRenderState p_418222_) {
            if (this.itemStates == null) {
                this.itemStates = new ArrayList<GuiItemRenderState>();
            }
            this.itemStates.add(p_418222_);
        }

        public void submitText(GuiTextRenderState p_418089_) {
            if (this.textStates == null) {
                this.textStates = new ArrayList<GuiTextRenderState>();
            }
            this.textStates.add(p_418089_);
        }

        public void submitPicturesInPictureState(PictureInPictureRenderState p_418088_) {
            if (this.picturesInPictureStates == null) {
                this.picturesInPictureStates = new ArrayList<PictureInPictureRenderState>();
            }
            this.picturesInPictureStates.add(p_418088_);
        }

        public void submitGuiElement(GuiElementRenderState p_418022_) {
            if (this.elementStates == null) {
                this.elementStates = new ArrayList<GuiElementRenderState>();
            }
            this.elementStates.add(p_418022_);
        }

        public void submitGlyph(GuiElementRenderState p_427510_) {
            if (this.glyphStates == null) {
                this.glyphStates = new ArrayList<GuiElementRenderState>();
            }
            this.glyphStates.add(p_427510_);
        }
    }

    public static interface LayeredElementConsumer {
        public void accept(GuiElementRenderState var1, int var2);
    }

    public static enum TraverseRange {
        ALL,
        BEFORE_BLUR,
        AFTER_BLUR;

    }
}

