/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.glyphs;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import org.joml.Matrix4f;

public class BakedGlyph {
    public static final float Z_FIGHTER = 0.001f;
    private final GlyphRenderTypes renderTypes;
    @Nullable
    private final GpuTextureView textureView;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;
    private final float left;
    private final float right;
    private final float up;
    private final float down;

    public BakedGlyph(GlyphRenderTypes p_285527_, @Nullable GpuTextureView p_423519_, float p_285271_, float p_284970_, float p_285098_, float p_285023_, float p_285242_, float p_285043_, float p_285100_, float p_284948_) {
        this.renderTypes = p_285527_;
        this.textureView = p_423519_;
        this.u0 = p_285271_;
        this.u1 = p_284970_;
        this.v0 = p_285098_;
        this.v1 = p_285023_;
        this.left = p_285242_;
        this.right = p_285043_;
        this.up = p_285100_;
        this.down = p_284948_;
    }

    public float left(GlyphInstance p_425981_) {
        return p_425981_.x + this.left + (p_425981_.style.isItalic() ? Math.min(this.shearTop(), this.shearBottom()) : 0.0f) - BakedGlyph.extraThickness(p_425981_.style.isBold());
    }

    public float top(GlyphInstance p_425830_) {
        return p_425830_.y + this.up - BakedGlyph.extraThickness(p_425830_.style.isBold());
    }

    public float right(GlyphInstance p_425891_) {
        return p_425891_.x + this.right + (p_425891_.hasShadow() ? p_425891_.shadowOffset : 0.0f) + (p_425891_.style.isItalic() ? Math.max(this.shearTop(), this.shearBottom()) : 0.0f) + BakedGlyph.extraThickness(p_425891_.style.isBold());
    }

    public float bottom(GlyphInstance p_425790_) {
        return p_425790_.y + this.down + (p_425790_.hasShadow() ? p_425790_.shadowOffset : 0.0f) + BakedGlyph.extraThickness(p_425790_.style.isBold());
    }

    public void renderChar(GlyphInstance p_380988_, Matrix4f p_381023_, VertexConsumer p_381084_, int p_381113_, boolean p_427402_) {
        float $$14;
        float $$11;
        Style $$5 = p_380988_.style();
        boolean $$6 = $$5.isItalic();
        float $$7 = p_380988_.x();
        float $$8 = p_380988_.y();
        int $$9 = p_380988_.color();
        boolean $$10 = $$5.isBold();
        float f = $$11 = p_427402_ ? 0.0f : 0.001f;
        if (p_380988_.hasShadow()) {
            int $$12 = p_380988_.shadowColor();
            this.render($$6, $$7 + p_380988_.shadowOffset(), $$8 + p_380988_.shadowOffset(), 0.0f, p_381023_, p_381084_, $$12, $$10, p_381113_);
            if ($$10) {
                this.render($$6, $$7 + p_380988_.boldOffset() + p_380988_.shadowOffset(), $$8 + p_380988_.shadowOffset(), $$11, p_381023_, p_381084_, $$12, true, p_381113_);
            }
            float $$13 = p_427402_ ? 0.0f : 0.03f;
        } else {
            $$14 = 0.0f;
        }
        this.render($$6, $$7, $$8, $$14, p_381023_, p_381084_, $$9, $$10, p_381113_);
        if ($$10) {
            this.render($$6, $$7 + p_380988_.boldOffset(), $$8, $$14 + $$11, p_381023_, p_381084_, $$9, true, p_381113_);
        }
    }

    private void render(boolean p_383040_, float p_382836_, float p_382914_, float p_382815_, Matrix4f p_382916_, VertexConsumer p_382963_, int p_383056_, boolean p_382998_, int p_382909_) {
        float $$9 = p_382836_ + this.left;
        float $$10 = p_382836_ + this.right;
        float $$11 = p_382914_ + this.up;
        float $$12 = p_382914_ + this.down;
        float $$13 = p_383040_ ? this.shearTop() : 0.0f;
        float $$14 = p_383040_ ? this.shearBottom() : 0.0f;
        float $$15 = BakedGlyph.extraThickness(p_382998_);
        p_382963_.addVertex(p_382916_, $$9 + $$13 - $$15, $$11 - $$15, p_382815_).setColor(p_383056_).setUv(this.u0, this.v0).setLight(p_382909_);
        p_382963_.addVertex(p_382916_, $$9 + $$14 - $$15, $$12 + $$15, p_382815_).setColor(p_383056_).setUv(this.u0, this.v1).setLight(p_382909_);
        p_382963_.addVertex(p_382916_, $$10 + $$14 + $$15, $$12 + $$15, p_382815_).setColor(p_383056_).setUv(this.u1, this.v1).setLight(p_382909_);
        p_382963_.addVertex(p_382916_, $$10 + $$13 + $$15, $$11 - $$15, p_382815_).setColor(p_383056_).setUv(this.u1, this.v0).setLight(p_382909_);
    }

    private static float extraThickness(boolean p_426036_) {
        return p_426036_ ? 0.1f : 0.0f;
    }

    private float shearBottom() {
        return 1.0f - 0.25f * this.down;
    }

    private float shearTop() {
        return 1.0f - 0.25f * this.up;
    }

    public void renderEffect(Effect p_95221_, Matrix4f p_254370_, VertexConsumer p_95223_, int p_95224_, boolean p_427269_) {
        float $$5;
        float f = $$5 = p_427269_ ? 0.0f : p_95221_.depth;
        if (p_95221_.hasShadow()) {
            this.buildEffect(p_95221_, p_95221_.shadowOffset(), $$5, p_95221_.shadowColor(), p_95223_, p_95224_, p_254370_);
            $$5 += p_427269_ ? 0.0f : 0.03f;
        }
        this.buildEffect(p_95221_, 0.0f, $$5, p_95221_.color, p_95223_, p_95224_, p_254370_);
    }

    private void buildEffect(Effect p_382788_, float p_383227_, float p_382946_, int p_382966_, VertexConsumer p_383218_, int p_382874_, Matrix4f p_383104_) {
        p_383218_.addVertex(p_383104_, p_382788_.x0 + p_383227_, p_382788_.y1 + p_383227_, p_382946_).setColor(p_382966_).setUv(this.u0, this.v0).setLight(p_382874_);
        p_383218_.addVertex(p_383104_, p_382788_.x1 + p_383227_, p_382788_.y1 + p_383227_, p_382946_).setColor(p_382966_).setUv(this.u0, this.v1).setLight(p_382874_);
        p_383218_.addVertex(p_383104_, p_382788_.x1 + p_383227_, p_382788_.y0 + p_383227_, p_382946_).setColor(p_382966_).setUv(this.u1, this.v1).setLight(p_382874_);
        p_383218_.addVertex(p_383104_, p_382788_.x0 + p_383227_, p_382788_.y0 + p_383227_, p_382946_).setColor(p_382966_).setUv(this.u1, this.v0).setLight(p_382874_);
    }

    @Nullable
    public GpuTextureView textureView() {
        return this.textureView;
    }

    public RenderPipeline guiPipeline() {
        return this.renderTypes.guiPipeline();
    }

    public RenderType renderType(Font.DisplayMode p_181388_) {
        return this.renderTypes.select(p_181388_);
    }

    public record GlyphInstance(float x, float y, int color, int shadowColor, BakedGlyph glyph, Style style, float boldOffset, float shadowOffset) {
        public float left() {
            return this.glyph.left(this);
        }

        public float top() {
            return this.glyph.top(this);
        }

        public float right() {
            return this.glyph.right(this);
        }

        public float bottom() {
            return this.glyph.bottom(this);
        }

        boolean hasShadow() {
            return this.shadowColor() != 0;
        }
    }

    public record Effect(float x0, float y0, float x1, float y1, float depth, int color, int shadowColor, float shadowOffset) {
        public Effect(float p_95247_, float p_95248_, float p_95249_, float p_95250_, float p_95251_, int p_379708_) {
            this(p_95247_, p_95248_, p_95249_, p_95250_, p_95251_, p_379708_, 0, 0.0f);
        }

        public float left() {
            return this.x0;
        }

        public float top() {
            return this.y0;
        }

        public float right() {
            return this.x1 + (this.hasShadow() ? this.shadowOffset : 0.0f);
        }

        public float bottom() {
            return this.y1 + (this.hasShadow() ? this.shadowOffset : 0.0f);
        }

        boolean hasShadow() {
            return this.shadowColor() != 0;
        }
    }
}

