/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public class SystemToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("toast/system");
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final SystemToastId id;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;
    private boolean forceHide;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public SystemToast(SystemToastId p_314596_, Component p_94833_, @Nullable Component p_94834_) {
        this(p_314596_, p_94833_, (List<FormattedCharSequence>)SystemToast.nullToEmpty(p_94834_), Math.max(160, 30 + Math.max(Minecraft.getInstance().font.width(p_94833_), p_94834_ == null ? 0 : Minecraft.getInstance().font.width(p_94834_))));
    }

    public static SystemToast multiline(Minecraft p_94848_, SystemToastId p_314435_, Component p_94850_, Component p_94851_) {
        Font $$4 = p_94848_.font;
        List<FormattedCharSequence> $$5 = $$4.split(p_94851_, 200);
        int $$6 = Math.max(200, $$5.stream().mapToInt($$4::width).max().orElse(200));
        return new SystemToast(p_314435_, p_94850_, $$5, $$6 + 30);
    }

    private SystemToast(SystemToastId p_314467_, Component p_94828_, List<FormattedCharSequence> p_94829_, int p_94830_) {
        this.id = p_314467_;
        this.title = p_94828_;
        this.messageLines = p_94829_;
        this.width = p_94830_;
    }

    private static ImmutableList<FormattedCharSequence> nullToEmpty(@Nullable Component p_94861_) {
        return p_94861_ == null ? ImmutableList.of() : ImmutableList.of((Object)p_94861_.getVisualOrderText());
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public void forceHide() {
        this.forceHide = true;
    }

    @Override
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    @Override
    public void update(ToastManager p_364721_, long p_364544_) {
        if (this.changed) {
            this.lastChanged = p_364544_;
            this.changed = false;
        }
        double $$2 = (double)this.id.displayTime * p_364721_.getNotificationDisplayTimeMultiplier();
        long $$3 = p_364544_ - this.lastChanged;
        this.wantedVisibility = !this.forceHide && (double)$$3 < $$2 ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    @Override
    public void render(GuiGraphics p_281624_, Font p_364768_, long p_282762_) {
        p_281624_.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        if (this.messageLines.isEmpty()) {
            p_281624_.drawString(p_364768_, this.title, 18, 12, -256, false);
        } else {
            p_281624_.drawString(p_364768_, this.title, 18, 7, -256, false);
            for (int $$3 = 0; $$3 < this.messageLines.size(); ++$$3) {
                p_281624_.drawString(p_364768_, this.messageLines.get($$3), 18, 18 + $$3 * 12, -1, false);
            }
        }
    }

    public void reset(Component p_94863_, @Nullable Component p_94864_) {
        this.title = p_94863_;
        this.messageLines = SystemToast.nullToEmpty(p_94864_);
        this.changed = true;
    }

    @Override
    public SystemToastId getToken() {
        return this.id;
    }

    public static void add(ToastManager p_361789_, SystemToastId p_314591_, Component p_94858_, @Nullable Component p_94859_) {
        p_361789_.addToast(new SystemToast(p_314591_, p_94858_, p_94859_));
    }

    public static void addOrUpdate(ToastManager p_362595_, SystemToastId p_314579_, Component p_94872_, @Nullable Component p_94873_) {
        SystemToast $$4 = p_362595_.getToast(SystemToast.class, p_314579_);
        if ($$4 == null) {
            SystemToast.add(p_362595_, p_314579_, p_94872_, p_94873_);
        } else {
            $$4.reset(p_94872_, p_94873_);
        }
    }

    public static void forceHide(ToastManager p_361781_, SystemToastId p_314474_) {
        SystemToast $$2 = p_361781_.getToast(SystemToast.class, p_314474_);
        if ($$2 != null) {
            $$2.forceHide();
        }
    }

    public static void onWorldAccessFailure(Minecraft p_94853_, String p_94854_) {
        SystemToast.add(p_94853_.getToastManager(), SystemToastId.WORLD_ACCESS_FAILURE, Component.translatable("selectWorld.access_failure"), Component.literal(p_94854_));
    }

    public static void onWorldDeleteFailure(Minecraft p_94867_, String p_94868_) {
        SystemToast.add(p_94867_.getToastManager(), SystemToastId.WORLD_ACCESS_FAILURE, Component.translatable("selectWorld.delete_failure"), Component.literal(p_94868_));
    }

    public static void onPackCopyFailure(Minecraft p_94876_, String p_94877_) {
        SystemToast.add(p_94876_.getToastManager(), SystemToastId.PACK_COPY_FAILURE, Component.translatable("pack.copyFailure"), Component.literal(p_94877_));
    }

    public static void onFileDropFailure(Minecraft p_350375_, int p_350447_) {
        SystemToast.add(p_350375_.getToastManager(), SystemToastId.FILE_DROP_FAILURE, Component.translatable("gui.fileDropFailure.title"), Component.translatable("gui.fileDropFailure.detail", p_350447_));
    }

    public static void onLowDiskSpace(Minecraft p_331174_) {
        SystemToast.addOrUpdate(p_331174_.getToastManager(), SystemToastId.LOW_DISK_SPACE, Component.translatable("chunk.toast.lowDiskSpace"), Component.translatable("chunk.toast.lowDiskSpace.description"));
    }

    public static void onChunkLoadFailure(Minecraft p_330933_, ChunkPos p_331933_) {
        SystemToast.addOrUpdate(p_330933_.getToastManager(), SystemToastId.CHUNK_LOAD_FAILURE, Component.translatable("chunk.toast.loadFailure", Component.translationArg(p_331933_)).withStyle(ChatFormatting.RED), Component.translatable("chunk.toast.checkLog"));
    }

    public static void onChunkSaveFailure(Minecraft p_331849_, ChunkPos p_330399_) {
        SystemToast.addOrUpdate(p_331849_.getToastManager(), SystemToastId.CHUNK_SAVE_FAILURE, Component.translatable("chunk.toast.saveFailure", Component.translationArg(p_330399_)).withStyle(ChatFormatting.RED), Component.translatable("chunk.toast.checkLog"));
    }

    @Override
    public /* synthetic */ Object getToken() {
        return this.getToken();
    }

    public static class SystemToastId {
        public static final SystemToastId NARRATOR_TOGGLE = new SystemToastId();
        public static final SystemToastId WORLD_BACKUP = new SystemToastId();
        public static final SystemToastId PACK_LOAD_FAILURE = new SystemToastId();
        public static final SystemToastId WORLD_ACCESS_FAILURE = new SystemToastId();
        public static final SystemToastId PACK_COPY_FAILURE = new SystemToastId();
        public static final SystemToastId FILE_DROP_FAILURE = new SystemToastId();
        public static final SystemToastId PERIODIC_NOTIFICATION = new SystemToastId();
        public static final SystemToastId LOW_DISK_SPACE = new SystemToastId(10000L);
        public static final SystemToastId CHUNK_LOAD_FAILURE = new SystemToastId();
        public static final SystemToastId CHUNK_SAVE_FAILURE = new SystemToastId();
        public static final SystemToastId UNSECURE_SERVER_WARNING = new SystemToastId(10000L);
        final long displayTime;

        public SystemToastId(long p_314425_) {
            this.displayTime = p_314425_;
        }

        public SystemToastId() {
            this(5000L);
        }
    }
}

