/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.tabs;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.sounds.SoundEvents;

public class TabManager {
    private final Consumer<AbstractWidget> addWidget;
    private final Consumer<AbstractWidget> removeWidget;
    private final Consumer<Tab> onSelected;
    private final Consumer<Tab> onDeselected;
    @Nullable
    private Tab currentTab;
    @Nullable
    private ScreenRectangle tabArea;

    public TabManager(Consumer<AbstractWidget> p_268279_, Consumer<AbstractWidget> p_268196_) {
        this(p_268279_, p_268196_, p_419709_ -> {}, p_419497_ -> {});
    }

    public TabManager(Consumer<AbstractWidget> p_419899_, Consumer<AbstractWidget> p_419824_, Consumer<Tab> p_419674_, Consumer<Tab> p_419801_) {
        this.addWidget = p_419899_;
        this.removeWidget = p_419824_;
        this.onSelected = p_419674_;
        this.onDeselected = p_419801_;
    }

    public void setTabArea(ScreenRectangle p_268042_) {
        this.tabArea = p_268042_;
        Tab $$1 = this.getCurrentTab();
        if ($$1 != null) {
            $$1.doLayout(p_268042_);
        }
    }

    public void setCurrentTab(Tab p_276109_, boolean p_276120_) {
        if (!Objects.equals(this.currentTab, p_276109_)) {
            if (this.currentTab != null) {
                this.currentTab.visitChildren(this.removeWidget);
            }
            Tab $$2 = this.currentTab;
            this.currentTab = p_276109_;
            p_276109_.visitChildren(this.addWidget);
            if (this.tabArea != null) {
                p_276109_.doLayout(this.tabArea);
            }
            if (p_276120_) {
                Minecraft.getInstance().getSoundManager().play(SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            }
            this.onDeselected.accept($$2);
            this.onSelected.accept(this.currentTab);
        }
    }

    @Nullable
    public Tab getCurrentTab() {
        return this.currentTab;
    }
}

