/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public interface MultiLineLabel {
    public static final MultiLineLabel EMPTY = new MultiLineLabel(){

        @Override
        public void renderCentered(GuiGraphics p_283287_, int p_94383_, int p_94384_) {
        }

        @Override
        public void renderCentered(GuiGraphics p_283208_, int p_210825_, int p_210826_, int p_210827_, int p_210828_) {
        }

        @Override
        public void renderLeftAligned(GuiGraphics p_283077_, int p_94379_, int p_94380_, int p_282157_, int p_282742_) {
        }

        @Override
        public int renderLeftAlignedNoShadow(GuiGraphics p_283645_, int p_94389_, int p_94390_, int p_94391_, int p_94392_) {
            return p_94390_;
        }

        @Override
        @Nullable
        public Style getStyleAtCentered(int p_428496_, int p_428494_, int p_428214_, double p_428350_, double p_428386_) {
            return null;
        }

        @Override
        @Nullable
        public Style getStyleAtLeftAligned(int p_428315_, int p_428452_, int p_428228_, double p_428428_, double p_428510_) {
            return null;
        }

        @Override
        public int getLineCount() {
            return 0;
        }

        @Override
        public int getWidth() {
            return 0;
        }
    };

    public static MultiLineLabel create(Font p_94351_, Component ... p_94352_) {
        return MultiLineLabel.create(p_94351_, Integer.MAX_VALUE, Integer.MAX_VALUE, p_94352_);
    }

    public static MultiLineLabel create(Font p_94346_, int p_94348_, Component ... p_352900_) {
        return MultiLineLabel.create(p_94346_, p_94348_, Integer.MAX_VALUE, p_352900_);
    }

    public static MultiLineLabel create(Font p_169037_, Component p_352901_, int p_352917_) {
        return MultiLineLabel.create(p_169037_, p_352917_, Integer.MAX_VALUE, p_352901_);
    }

    public static MultiLineLabel create(final Font p_94342_, final int p_94344_, final int p_352914_, final Component ... p_352955_) {
        if (p_352955_.length == 0) {
            return EMPTY;
        }
        return new MultiLineLabel(){
            @Nullable
            private List<TextAndWidth> cachedTextAndWidth;
            @Nullable
            private Language splitWithLanguage;

            @Override
            public void renderCentered(GuiGraphics p_281603_, int p_281267_, int p_281819_) {
                this.renderCentered(p_281603_, p_281267_, p_281819_, p_94342_.lineHeight, -1);
            }

            @Override
            public void renderCentered(GuiGraphics p_283492_, int p_283184_, int p_282078_, int p_352944_, int p_352919_) {
                int $$5 = p_282078_;
                for (TextAndWidth $$6 : this.getSplitMessage()) {
                    p_283492_.drawString(p_94342_, $$6.text, p_283184_ - $$6.width / 2, $$5, p_352919_);
                    $$5 += p_352944_;
                }
            }

            @Override
            public void renderLeftAligned(GuiGraphics p_282318_, int p_283665_, int p_283416_, int p_281919_, int p_281686_) {
                int $$5 = p_283416_;
                for (TextAndWidth $$6 : this.getSplitMessage()) {
                    p_282318_.drawString(p_94342_, $$6.text, p_283665_, $$5, p_281686_);
                    $$5 += p_281919_;
                }
            }

            @Override
            public int renderLeftAlignedNoShadow(GuiGraphics p_281782_, int p_282841_, int p_283554_, int p_282768_, int p_283499_) {
                int $$5 = p_283554_;
                for (TextAndWidth $$6 : this.getSplitMessage()) {
                    p_281782_.drawString(p_94342_, $$6.text, p_282841_, $$5, p_283499_, false);
                    $$5 += p_282768_;
                }
                return $$5;
            }

            @Override
            @Nullable
            public Style getStyleAtCentered(int p_428222_, int p_428223_, int p_428447_, double p_428232_, double p_428416_) {
                List<TextAndWidth> $$5 = this.getSplitMessage();
                int $$6 = Mth.floor((p_428416_ - (double)p_428223_) / (double)p_428447_);
                if ($$6 < 0 || $$6 >= $$5.size()) {
                    return null;
                }
                TextAndWidth $$7 = $$5.get($$6);
                int $$8 = p_428222_ - $$7.width / 2;
                if (p_428232_ < (double)$$8) {
                    return null;
                }
                int $$9 = Mth.floor(p_428232_ - (double)$$8);
                return p_94342_.getSplitter().componentStyleAtWidth($$7.text, $$9);
            }

            @Override
            @Nullable
            public Style getStyleAtLeftAligned(int p_428507_, int p_428486_, int p_428523_, double p_428529_, double p_428439_) {
                if (p_428529_ < (double)p_428507_) {
                    return null;
                }
                List<TextAndWidth> $$5 = this.getSplitMessage();
                int $$6 = Mth.floor((p_428439_ - (double)p_428486_) / (double)p_428523_);
                if ($$6 < 0 || $$6 >= $$5.size()) {
                    return null;
                }
                TextAndWidth $$7 = $$5.get($$6);
                int $$8 = Mth.floor(p_428529_ - (double)p_428507_);
                return p_94342_.getSplitter().componentStyleAtWidth($$7.text, $$8);
            }

            private List<TextAndWidth> getSplitMessage() {
                Language $$0 = Language.getInstance();
                if (this.cachedTextAndWidth != null && $$0 == this.splitWithLanguage) {
                    return this.cachedTextAndWidth;
                }
                this.splitWithLanguage = $$0;
                ArrayList<FormattedText> $$1 = new ArrayList<FormattedText>();
                for (Component $$2 : p_352955_) {
                    $$1.addAll(p_94342_.splitIgnoringLanguage($$2, p_94344_));
                }
                this.cachedTextAndWidth = new ArrayList<TextAndWidth>();
                int $$3 = Math.min($$1.size(), p_352914_);
                List $$4 = $$1.subList(0, $$3);
                for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                    FormattedText $$6 = (FormattedText)$$4.get($$5);
                    FormattedCharSequence $$7 = Language.getInstance().getVisualOrder($$6);
                    if ($$5 == $$4.size() - 1 && $$3 == p_352914_ && $$3 != $$1.size()) {
                        FormattedText $$8 = p_94342_.substrByWidth($$6, p_94342_.width($$6) - p_94342_.width(CommonComponents.ELLIPSIS));
                        FormattedText $$9 = FormattedText.composite($$8, CommonComponents.ELLIPSIS);
                        this.cachedTextAndWidth.add(new TextAndWidth(Language.getInstance().getVisualOrder($$9), p_94342_.width($$9)));
                        continue;
                    }
                    this.cachedTextAndWidth.add(new TextAndWidth($$7, p_94342_.width($$7)));
                }
                return this.cachedTextAndWidth;
            }

            @Override
            public int getLineCount() {
                return this.getSplitMessage().size();
            }

            @Override
            public int getWidth() {
                return Math.min(p_94344_, this.getSplitMessage().stream().mapToInt(TextAndWidth::width).max().orElse(0));
            }
        };
    }

    public void renderCentered(GuiGraphics var1, int var2, int var3);

    public void renderCentered(GuiGraphics var1, int var2, int var3, int var4, int var5);

    public void renderLeftAligned(GuiGraphics var1, int var2, int var3, int var4, int var5);

    public int renderLeftAlignedNoShadow(GuiGraphics var1, int var2, int var3, int var4, int var5);

    @Nullable
    public Style getStyleAtCentered(int var1, int var2, int var3, double var4, double var6);

    @Nullable
    public Style getStyleAtLeftAligned(int var1, int var2, int var3, double var4, double var6);

    public int getLineCount();

    public int getWidth();

    public record TextAndWidth(FormattedCharSequence text, int width) {
    }
}

