/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModelProvider
implements DataProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;

    public ModelProvider(PackOutput p_388260_) {
        this.blockStatePathProvider = p_388260_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = p_388260_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = p_388260_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_387857_) {
        ItemInfoCollector $$1 = new ItemInfoCollector();
        BlockStateGeneratorCollector $$2 = new BlockStateGeneratorCollector();
        SimpleModelCollector $$3 = new SimpleModelCollector();
        new BlockModelGenerators($$2, $$1, $$3).run();
        new ItemModelGenerators($$1, $$3).run();
        $$2.validate();
        $$1.finalizeAndValidate();
        return CompletableFuture.allOf($$2.save(p_387857_, this.blockStatePathProvider), $$3.save(p_387857_, this.modelPathProvider), $$1.save(p_387857_, this.itemInfoPathProvider));
    }

    @Override
    public final String getName() {
        return "Model Definitions";
    }

    static class ItemInfoCollector
    implements ItemModelOutput {
        private final Map<Item, ClientItem> itemInfos = new HashMap<Item, ClientItem>();
        private final Map<Item, Item> copies = new HashMap<Item, Item>();

        ItemInfoCollector() {
        }

        @Override
        public void accept(Item p_387063_, ItemModel.Unbaked p_388578_) {
            this.register(p_387063_, new ClientItem(p_388578_, ClientItem.Properties.DEFAULT));
        }

        private void register(Item p_388205_, ClientItem p_388233_) {
            ClientItem $$2 = this.itemInfos.put(p_388205_, p_388233_);
            if ($$2 != null) {
                throw new IllegalStateException("Duplicate item model definition for " + String.valueOf(p_388205_));
            }
        }

        @Override
        public void copy(Item p_386920_, Item p_386789_) {
            this.copies.put(p_386789_, p_386920_);
        }

        public void finalizeAndValidate() {
            BuiltInRegistries.ITEM.forEach(p_388426_ -> {
                BlockItem $$1;
                if (this.copies.containsKey(p_388426_)) {
                    return;
                }
                if (p_388426_ instanceof BlockItem && !this.itemInfos.containsKey($$1 = (BlockItem)p_388426_)) {
                    ResourceLocation $$2 = ModelLocationUtils.getModelLocation($$1.getBlock());
                    this.accept($$1, ItemModelUtils.plainModel($$2));
                }
            });
            this.copies.forEach((p_386494_, p_386575_) -> {
                ClientItem $$2 = this.itemInfos.get(p_386575_);
                if ($$2 == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(p_386575_) + " -> " + String.valueOf(p_386494_));
                }
                this.register((Item)p_386494_, $$2);
            });
            List<ResourceLocation> $$0 = BuiltInRegistries.ITEM.listElements().filter(p_388636_ -> !this.itemInfos.containsKey(p_388636_.value())).map(p_388278_ -> p_388278_.key().location()).toList();
            if (!$$0.isEmpty()) {
                throw new IllegalStateException("Missing item model definitions for: " + String.valueOf($$0));
            }
        }

        public CompletableFuture<?> save(CachedOutput p_387552_, PackOutput.PathProvider p_388501_) {
            return DataProvider.saveAll(p_387552_, ClientItem.CODEC, p_388594_ -> p_388501_.json(p_388594_.builtInRegistryHolder().key().location()), this.itemInfos);
        }
    }

    static class BlockStateGeneratorCollector
    implements Consumer<BlockModelDefinitionGenerator> {
        private final Map<Block, BlockModelDefinitionGenerator> generators = new HashMap<Block, BlockModelDefinitionGenerator>();

        BlockStateGeneratorCollector() {
        }

        @Override
        public void accept(BlockModelDefinitionGenerator p_405192_) {
            Block $$1 = p_405192_.block();
            BlockModelDefinitionGenerator $$2 = this.generators.put($$1, p_405192_);
            if ($$2 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf($$1));
            }
        }

        public void validate() {
            Stream<Holder.Reference> $$0 = BuiltInRegistries.BLOCK.listElements().filter(p_388333_ -> true);
            List<ResourceLocation> $$1 = $$0.filter(p_386843_ -> !this.generators.containsKey(p_386843_.value())).map(p_386823_ -> p_386823_.key().location()).toList();
            if (!$$1.isEmpty()) {
                throw new IllegalStateException("Missing blockstate definitions for: " + String.valueOf($$1));
            }
        }

        public CompletableFuture<?> save(CachedOutput p_388014_, PackOutput.PathProvider p_388192_) {
            Map $$2 = Maps.transformValues(this.generators, BlockModelDefinitionGenerator::create);
            Function<Block, Path> $$3 = p_387598_ -> p_388192_.json(p_387598_.builtInRegistryHolder().key().location());
            return DataProvider.saveAll(p_388014_, BlockModelDefinition.CODEC, $$3, $$2);
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.accept((BlockModelDefinitionGenerator)object);
        }
    }

    static class SimpleModelCollector
    implements BiConsumer<ResourceLocation, ModelInstance> {
        private final Map<ResourceLocation, ModelInstance> models = new HashMap<ResourceLocation, ModelInstance>();

        SimpleModelCollector() {
        }

        @Override
        public void accept(ResourceLocation p_388633_, ModelInstance p_388119_) {
            Supplier $$2 = this.models.put(p_388633_, p_388119_);
            if ($$2 != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(p_388633_));
            }
        }

        public CompletableFuture<?> save(CachedOutput p_386795_, PackOutput.PathProvider p_388673_) {
            return DataProvider.saveAll(p_386795_, Supplier::get, p_388673_::json, this.models);
        }

        @Override
        public /* synthetic */ void accept(Object object, Object object2) {
            this.accept((ResourceLocation)object, (ModelInstance)object2);
        }
    }
}

