/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public class EquipmentAssetProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public EquipmentAssetProvider(PackOutput p_387559_) {
        this.pathProvider = p_387559_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
    }

    private static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> p_387865_) {
        p_387865_.accept(EquipmentAssets.LEATHER, EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather"), true).addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather_overlay"), false).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, EquipmentClientInfo.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace("leather"), true)).build());
        p_387865_.accept(EquipmentAssets.CHAINMAIL, EquipmentAssetProvider.onlyHumanoid("chainmail"));
        p_387865_.accept(EquipmentAssets.IRON, EquipmentAssetProvider.humanoidAndHorse("iron"));
        p_387865_.accept(EquipmentAssets.GOLD, EquipmentAssetProvider.humanoidAndHorse("gold"));
        p_387865_.accept(EquipmentAssets.DIAMOND, EquipmentAssetProvider.humanoidAndHorse("diamond"));
        p_387865_.accept(EquipmentAssets.TURTLE_SCUTE, EquipmentClientInfo.builder().addMainHumanoidLayer(ResourceLocation.withDefaultNamespace("turtle_scute"), false).build());
        p_387865_.accept(EquipmentAssets.NETHERITE, EquipmentAssetProvider.onlyHumanoid("netherite"));
        p_387865_.accept(EquipmentAssets.ARMADILLO_SCUTE, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.WOLF_BODY, EquipmentClientInfo.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute"), false)).addLayers(EquipmentClientInfo.LayerType.WOLF_BODY, EquipmentClientInfo.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute_overlay"), true)).build());
        p_387865_.accept(EquipmentAssets.ELYTRA, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.WINGS, new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("elytra"), Optional.empty(), true)).build());
        EquipmentClientInfo.Layer $$1 = new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("saddle"));
        p_387865_.accept(EquipmentAssets.SADDLE, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.PIG_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.STRIDER_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.CAMEL_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.HORSE_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.DONKEY_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.MULE_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.SKELETON_HORSE_SADDLE, $$1).addLayers(EquipmentClientInfo.LayerType.ZOMBIE_HORSE_SADDLE, $$1).build());
        for (Map.Entry<DyeColor, ResourceKey<EquipmentAsset>> $$2 : EquipmentAssets.HARNESSES.entrySet()) {
            DyeColor $$3 = $$2.getKey();
            ResourceKey<EquipmentAsset> $$4 = $$2.getValue();
            p_387865_.accept($$4, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.HAPPY_GHAST_BODY, EquipmentClientInfo.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace($$3.getSerializedName() + "_harness"), false)).build());
        }
        for (Map.Entry<DyeColor, ResourceKey<EquipmentAsset>> $$5 : EquipmentAssets.CARPETS.entrySet()) {
            DyeColor $$6 = $$5.getKey();
            ResourceKey<EquipmentAsset> $$7 = $$5.getValue();
            p_387865_.accept($$7, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.LLAMA_BODY, new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace($$6.getSerializedName()))).build());
        }
        p_387865_.accept(EquipmentAssets.TRADER_LLAMA, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.LLAMA_BODY, new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("trader_llama"))).build());
    }

    private static EquipmentClientInfo onlyHumanoid(String p_388505_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(p_388505_)).build();
    }

    private static EquipmentClientInfo humanoidAndHorse(String p_386720_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(p_386720_)).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, EquipmentClientInfo.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace(p_386720_), false)).build();
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_387304_) {
        HashMap $$1 = new HashMap();
        EquipmentAssetProvider.bootstrap((p_386976_, p_388942_) -> {
            if ($$1.putIfAbsent(p_386976_, p_388942_) != null) {
                throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(p_386976_));
            }
        });
        return DataProvider.saveAll(p_387304_, EquipmentClientInfo.CODEC, this.pathProvider::json, $$1);
    }

    @Override
    public String getName() {
        return "Equipment Asset Definitions";
    }
}

