/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color.block;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockColors {
    private static final int DEFAULT = -1;
    public static final int LILY_PAD_IN_WORLD = -14647248;
    public static final int LILY_PAD_DEFAULT = -9321636;
    private final IdMapper<BlockColor> blockColors = new IdMapper(32);
    private final Map<Block, Set<Property<?>>> coloringStates = Maps.newHashMap();

    public static BlockColors createDefault() {
        BlockColors $$0 = new BlockColors();
        $$0.register((p_276233_, p_276234_, p_276235_, p_276236_) -> {
            if (p_276234_ == null || p_276235_ == null) {
                return GrassColor.getDefaultColor();
            }
            return BiomeColors.getAverageGrassColor(p_276234_, p_276233_.getValue(DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? p_276235_.below() : p_276235_);
        }, Blocks.LARGE_FERN, Blocks.TALL_GRASS);
        $$0.addColoringState(DoublePlantBlock.HALF, Blocks.LARGE_FERN, Blocks.TALL_GRASS);
        $$0.register((p_276237_, p_276238_, p_276239_, p_276240_) -> {
            if (p_276238_ == null || p_276239_ == null) {
                return GrassColor.getDefaultColor();
            }
            return BiomeColors.getAverageGrassColor(p_276238_, p_276239_);
        }, Blocks.GRASS_BLOCK, Blocks.FERN, Blocks.SHORT_GRASS, Blocks.POTTED_FERN, Blocks.BUSH);
        $$0.register((p_276241_, p_276242_, p_276243_, p_276244_) -> {
            if (p_276244_ != 0) {
                if (p_276242_ == null || p_276243_ == null) {
                    return GrassColor.getDefaultColor();
                }
                return BiomeColors.getAverageGrassColor(p_276242_, p_276243_);
            }
            return -1;
        }, Blocks.PINK_PETALS, Blocks.WILDFLOWERS);
        $$0.register((p_386206_, p_386207_, p_386208_, p_386209_) -> -10380959, Blocks.SPRUCE_LEAVES);
        $$0.register((p_386198_, p_386199_, p_386200_, p_386201_) -> -8345771, Blocks.BIRCH_LEAVES);
        $$0.register((p_386202_, p_386203_, p_386204_, p_386205_) -> {
            if (p_386203_ == null || p_386204_ == null) {
                return -12012264;
            }
            return BiomeColors.getAverageFoliageColor(p_386203_, p_386204_);
        }, Blocks.OAK_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.VINE, Blocks.MANGROVE_LEAVES);
        $$0.register((p_406181_, p_406182_, p_406183_, p_406184_) -> {
            if (p_406182_ == null || p_406183_ == null) {
                return -10732494;
            }
            return BiomeColors.getAverageDryFoliageColor(p_406182_, p_406183_);
        }, Blocks.LEAF_LITTER);
        $$0.register((p_92621_, p_92622_, p_92623_, p_92624_) -> {
            if (p_92622_ == null || p_92623_ == null) {
                return -1;
            }
            return BiomeColors.getAverageWaterColor(p_92622_, p_92623_);
        }, Blocks.WATER, Blocks.BUBBLE_COLUMN, Blocks.WATER_CAULDRON);
        $$0.register((p_92616_, p_92617_, p_92618_, p_92619_) -> RedStoneWireBlock.getColorForPower(p_92616_.getValue(RedStoneWireBlock.POWER)), Blocks.REDSTONE_WIRE);
        $$0.addColoringState(RedStoneWireBlock.POWER, Blocks.REDSTONE_WIRE);
        $$0.register((p_92611_, p_92612_, p_92613_, p_92614_) -> {
            if (p_92612_ == null || p_92613_ == null) {
                return -1;
            }
            return BiomeColors.getAverageGrassColor(p_92612_, p_92613_);
        }, Blocks.SUGAR_CANE);
        $$0.register((p_92606_, p_92607_, p_92608_, p_92609_) -> -2046180, Blocks.ATTACHED_MELON_STEM, Blocks.ATTACHED_PUMPKIN_STEM);
        $$0.register((p_359066_, p_359067_, p_359068_, p_359069_) -> {
            int $$4 = p_359066_.getValue(StemBlock.AGE);
            return ARGB.color($$4 * 32, 255 - $$4 * 8, $$4 * 4);
        }, Blocks.MELON_STEM, Blocks.PUMPKIN_STEM);
        $$0.addColoringState(StemBlock.AGE, Blocks.MELON_STEM, Blocks.PUMPKIN_STEM);
        $$0.register((p_92596_, p_92597_, p_92598_, p_92599_) -> {
            if (p_92597_ == null || p_92598_ == null) {
                return -9321636;
            }
            return -14647248;
        }, Blocks.LILY_PAD);
        return $$0;
    }

    public int getColor(BlockState p_92583_, Level p_92584_, BlockPos p_92585_) {
        BlockColor $$3 = this.blockColors.byId(BuiltInRegistries.BLOCK.getId(p_92583_.getBlock()));
        if ($$3 != null) {
            return $$3.getColor(p_92583_, null, null, 0);
        }
        MapColor $$4 = p_92583_.getMapColor(p_92584_, p_92585_);
        return $$4 != null ? $$4.col : -1;
    }

    public int getColor(BlockState p_92578_, @Nullable BlockAndTintGetter p_92579_, @Nullable BlockPos p_92580_, int p_92581_) {
        BlockColor $$4 = this.blockColors.byId(BuiltInRegistries.BLOCK.getId(p_92578_.getBlock()));
        return $$4 == null ? -1 : $$4.getColor(p_92578_, p_92579_, p_92580_, p_92581_);
    }

    public void register(BlockColor p_92590_, Block ... p_92591_) {
        for (Block $$2 : p_92591_) {
            this.blockColors.addMapping(p_92590_, BuiltInRegistries.BLOCK.getId($$2));
        }
    }

    private void addColoringStates(Set<Property<?>> p_92593_, Block ... p_92594_) {
        for (Block $$2 : p_92594_) {
            this.coloringStates.put($$2, p_92593_);
        }
    }

    private void addColoringState(Property<?> p_92587_, Block ... p_92588_) {
        this.addColoringStates((Set<Property<?>>)ImmutableSet.of(p_92587_), p_92588_);
    }

    public Set<Property<?>> getColoringProperties(Block p_92576_) {
        return (Set)this.coloringStates.getOrDefault(p_92576_, (Set<Property<?>>)ImmutableSet.of());
    }
}

