/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class KeyframeAnimation {
    private final AnimationDefinition definition;
    private final List<Entry> entries;
    private final Vector3f scratchVector = new Vector3f();

    private KeyframeAnimation(AnimationDefinition p_427337_, List<Entry> p_427495_) {
        this.definition = p_427337_;
        this.entries = p_427495_;
    }

    static KeyframeAnimation bake(ModelPart p_427435_, AnimationDefinition p_427268_) {
        ArrayList<Entry> $$2 = new ArrayList<Entry>();
        Function<String, ModelPart> $$3 = p_427435_.createPartLookup();
        for (Map.Entry<String, List<AnimationChannel>> $$4 : p_427268_.boneAnimations().entrySet()) {
            String $$5 = $$4.getKey();
            List<AnimationChannel> $$6 = $$4.getValue();
            ModelPart $$7 = $$3.apply($$5);
            if ($$7 == null) {
                throw new IllegalArgumentException("Cannot animate " + $$5 + ", which does not exist in model");
            }
            for (AnimationChannel $$8 : $$6) {
                $$2.add(new Entry($$7, $$8.target(), $$8.keyframes()));
            }
        }
        return new KeyframeAnimation(p_427268_, List.copyOf($$2));
    }

    public void applyStatic() {
        this.apply(0L, 1.0f);
    }

    public void applyWalk(float p_427283_, float p_427496_, float p_427289_, float p_427296_) {
        long $$4 = (long)(p_427283_ * 50.0f * p_427289_);
        float $$5 = Math.min(p_427496_ * p_427296_, 1.0f);
        this.apply($$4, $$5);
    }

    public void apply(AnimationState p_427382_, float p_427471_) {
        this.apply(p_427382_, p_427471_, 1.0f);
    }

    public void apply(AnimationState p_427490_, float p_427480_, float p_427356_) {
        p_427490_.ifStarted(p_427385_ -> this.apply((long)((float)p_427385_.getTimeInMillis(p_427480_) * p_427356_), 1.0f));
    }

    public void apply(long p_427232_, float p_427346_) {
        float $$2 = this.getElapsedSeconds(p_427232_);
        for (Entry $$3 : this.entries) {
            $$3.apply($$2, p_427346_, this.scratchVector);
        }
    }

    private float getElapsedSeconds(long p_427362_) {
        float $$1 = (float)p_427362_ / 1000.0f;
        return this.definition.looping() ? $$1 % this.definition.lengthInSeconds() : $$1;
    }

    record Entry(ModelPart part, AnimationChannel.Target target, Keyframe[] keyframes) {
        public void apply(float p_427355_, float p_427277_, Vector3f p_427458_) {
            float $$9;
            int $$3 = Math.max(0, Mth.binarySearch(0, this.keyframes.length, p_427328_ -> p_427355_ <= this.keyframes[p_427328_].timestamp()) - 1);
            int $$4 = Math.min(this.keyframes.length - 1, $$3 + 1);
            Keyframe $$5 = this.keyframes[$$3];
            Keyframe $$6 = this.keyframes[$$4];
            float $$7 = p_427355_ - $$5.timestamp();
            if ($$4 != $$3) {
                float $$8 = Mth.clamp($$7 / ($$6.timestamp() - $$5.timestamp()), 0.0f, 1.0f);
            } else {
                $$9 = 0.0f;
            }
            $$6.interpolation().apply(p_427458_, $$9, this.keyframes, $$3, $$4, p_427277_);
            this.target.apply(this.part, p_427458_);
        }
    }
}

