/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import org.slf4j.Logger;

public class Screenshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SCREENSHOT_DIR = "screenshots";

    public static void grab(File p_92290_, RenderTarget p_92293_, Consumer<Component> p_92294_) {
        Screenshot.grab(p_92290_, null, p_92293_, 1, p_92294_);
    }

    public static void grab(File p_92296_, @Nullable String p_92297_, RenderTarget p_92300_, int p_423482_, Consumer<Component> p_92301_) {
        Screenshot.takeScreenshot(p_92300_, p_423482_, p_406180_ -> {
            File $$6;
            File $$4 = new File(p_92296_, SCREENSHOT_DIR);
            $$4.mkdir();
            if (p_92297_ == null) {
                File $$5 = Screenshot.getFile($$4);
            } else {
                $$6 = new File($$4, p_92297_);
            }
            Util.ioPool().execute(() -> {
                try (NativeImage nativeImage = p_406180_;){
                    p_406180_.writeToFile($$6);
                    MutableComponent $$3 = Component.literal($$6.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_392495_ -> p_392495_.withClickEvent(new ClickEvent.OpenFile($$6.getAbsoluteFile())));
                    p_92301_.accept(Component.translatable("screenshot.success", $$3));
                }
                catch (Exception $$4) {
                    LOGGER.warn("Couldn't save screenshot", (Throwable)$$4);
                    p_92301_.accept(Component.translatable("screenshot.failure", $$4.getMessage()));
                }
            });
        });
    }

    public static void takeScreenshot(RenderTarget p_92282_, Consumer<NativeImage> p_406336_) {
        Screenshot.takeScreenshot(p_92282_, 1, p_406336_);
    }

    public static void takeScreenshot(RenderTarget p_423538_, int p_423674_, Consumer<NativeImage> p_423666_) {
        int $$3 = p_423538_.width;
        int $$4 = p_423538_.height;
        GpuTexture $$5 = p_423538_.getColorTexture();
        if ($$5 == null) {
            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
        }
        if ($$3 % p_423674_ != 0 || $$4 % p_423674_ != 0) {
            throw new IllegalArgumentException("Image size is not divisible by downscale factor");
        }
        GpuBuffer $$6 = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", 9, $$3 * $$4 * $$5.getFormat().pixelSize());
        CommandEncoder $$7 = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer($$5, $$6, 0, () -> {
            try (GpuBuffer.MappedView $$7 = $$7.mapBuffer($$6, true, false);){
                int $$8 = $$4 / p_423674_;
                int $$9 = $$3 / p_423674_;
                NativeImage $$10 = new NativeImage($$9, $$8, false);
                for (int $$11 = 0; $$11 < $$8; ++$$11) {
                    for (int $$12 = 0; $$12 < $$9; ++$$12) {
                        if (p_423674_ == 1) {
                            int $$13 = $$7.data().getInt(($$12 + $$11 * $$3) * $$5.getFormat().pixelSize());
                            $$10.setPixelABGR($$12, $$4 - $$11 - 1, $$13 | 0xFF000000);
                            continue;
                        }
                        int $$14 = 0;
                        int $$15 = 0;
                        int $$16 = 0;
                        for (int $$17 = 0; $$17 < p_423674_; ++$$17) {
                            for (int $$18 = 0; $$18 < p_423674_; ++$$18) {
                                int $$19 = $$7.data().getInt(($$12 * p_423674_ + $$17 + ($$11 * p_423674_ + $$18) * $$3) * $$5.getFormat().pixelSize());
                                $$14 += ARGB.red($$19);
                                $$15 += ARGB.green($$19);
                                $$16 += ARGB.blue($$19);
                            }
                        }
                        int $$20 = p_423674_ * p_423674_;
                        $$10.setPixelABGR($$12, $$8 - $$11 - 1, ARGB.color(255, $$14 / $$20, $$15 / $$20, $$16 / $$20));
                    }
                }
                p_423666_.accept($$10);
            }
            $$6.close();
        }, 0);
    }

    private static File getFile(File p_92288_) {
        String $$1 = Util.getFilenameFormattedDateTime();
        int $$2 = 1;
        File $$3;
        while (($$3 = new File(p_92288_, $$1 + (String)($$2 == 1 ? "" : "_" + $$2) + ".png")).exists()) {
            ++$$2;
        }
        return $$3;
    }
}

