/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

public class ClientRecipeBook
extends RecipeBook {
    private final Map<RecipeDisplayId, RecipeDisplayEntry> known = new HashMap<RecipeDisplayId, RecipeDisplayEntry>();
    private final Set<RecipeDisplayId> highlight = new HashSet<RecipeDisplayId>();
    private Map<ExtendedRecipeBookCategory, List<RecipeCollection>> collectionsByTab = Map.of();
    private List<RecipeCollection> allCollections = List.of();

    public void add(RecipeDisplayEntry p_380259_) {
        this.known.put(p_380259_.id(), p_380259_);
    }

    public void remove(RecipeDisplayId p_379557_) {
        this.known.remove(p_379557_);
        this.highlight.remove(p_379557_);
    }

    public void clear() {
        this.known.clear();
        this.highlight.clear();
    }

    public boolean willHighlight(RecipeDisplayId p_379469_) {
        return this.highlight.contains(p_379469_);
    }

    public void removeHighlight(RecipeDisplayId p_379652_) {
        this.highlight.remove(p_379652_);
    }

    public void addHighlight(RecipeDisplayId p_380362_) {
        this.highlight.add(p_380362_);
    }

    public void rebuildCollections() {
        Map<RecipeBookCategory, List<List<RecipeDisplayEntry>>> $$0 = ClientRecipeBook.categorizeAndGroupRecipes(this.known.values());
        HashMap<SearchRecipeBookCategory, List> $$1 = new HashMap<SearchRecipeBookCategory, List>();
        ImmutableList.Builder $$2 = ImmutableList.builder();
        $$0.forEach((p_380933_, p_378767_) -> $$1.put((SearchRecipeBookCategory)p_380933_, (List)p_378767_.stream().map(RecipeCollection::new).peek(arg_0 -> ((ImmutableList.Builder)$$2).add(arg_0)).collect(ImmutableList.toImmutableList())));
        for (SearchRecipeBookCategory $$3 : SearchRecipeBookCategory.values()) {
            $$1.put($$3, (List)$$3.includedCategories().stream().flatMap(p_380954_ -> $$1.getOrDefault(p_380954_, List.of()).stream()).collect(ImmutableList.toImmutableList()));
        }
        this.collectionsByTab = Map.copyOf($$1);
        this.allCollections = $$2.build();
    }

    private static Map<RecipeBookCategory, List<List<RecipeDisplayEntry>>> categorizeAndGroupRecipes(Iterable<RecipeDisplayEntry> p_90643_) {
        HashMap<RecipeBookCategory, List<List<RecipeDisplayEntry>>> $$1 = new HashMap<RecipeBookCategory, List<List<RecipeDisplayEntry>>>();
        HashBasedTable $$2 = HashBasedTable.create();
        for (RecipeDisplayEntry $$3 : p_90643_) {
            RecipeBookCategory $$4 = $$3.category();
            OptionalInt $$5 = $$3.group();
            if ($$5.isEmpty()) {
                $$1.computeIfAbsent($$4, p_381000_ -> new ArrayList()).add(List.of($$3));
                continue;
            }
            ArrayList<RecipeDisplayEntry> $$6 = (ArrayList<RecipeDisplayEntry>)$$2.get((Object)$$4, (Object)$$5.getAsInt());
            if ($$6 == null) {
                $$6 = new ArrayList<RecipeDisplayEntry>();
                $$2.put((Object)$$4, (Object)$$5.getAsInt(), $$6);
                $$1.computeIfAbsent($$4, p_380998_ -> new ArrayList()).add($$6);
            }
            $$6.add($$3);
        }
        return $$1;
    }

    public List<RecipeCollection> getCollections() {
        return this.allCollections;
    }

    public List<RecipeCollection> getCollection(ExtendedRecipeBookCategory p_380958_) {
        return this.collectionsByTab.getOrDefault(p_380958_, Collections.emptyList());
    }
}

