/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnterBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_31270_, BlockState p_31271_) {
        this.trigger(p_31270_, (T p_31277_) -> p_31277_.matches(p_31271_));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Holder<Block>> block, Optional<StatePropertiesPredicate> state) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_359054_ -> p_359054_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)BuiltInRegistries.BLOCK.holderByNameCodec().optionalFieldOf("block").forGetter(TriggerInstance::block), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(TriggerInstance::state)).apply((Applicative)p_359054_, TriggerInstance::new)).validate(TriggerInstance::validate);

        private static DataResult<TriggerInstance> validate(TriggerInstance p_311841_) {
            return p_311841_.block.flatMap(p_311420_ -> p_311419_.state.flatMap(p_311412_ -> p_311412_.checkState(((Block)p_311420_.value()).getStateDefinition())).map(p_311418_ -> DataResult.error(() -> "Block" + String.valueOf(p_311420_) + " has no property " + p_311418_))).orElseGet(() -> DataResult.success((Object)p_311841_));
        }

        public static Criterion<TriggerInstance> entersBlock(Block p_31298_) {
            return CriteriaTriggers.ENTER_BLOCK.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(p_31298_.builtInRegistryHolder()), Optional.empty()));
        }

        public boolean matches(BlockState p_31300_) {
            if (this.block.isPresent() && !p_31300_.is(this.block.get())) {
                return false;
            }
            return !this.state.isPresent() || this.state.get().matches(p_31300_);
        }
    }
}

