/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class BredAnimalsTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_147279_, Animal p_147280_, Animal p_147281_, @Nullable AgeableMob p_147282_) {
        LootContext $$4 = EntityPredicate.createContext(p_147279_, p_147280_);
        LootContext $$5 = EntityPredicate.createContext(p_147279_, p_147281_);
        LootContext $$6 = p_147282_ != null ? EntityPredicate.createContext(p_147279_, p_147282_) : null;
        this.trigger(p_147279_, p_18653_ -> p_18653_.matches($$4, $$5, $$6));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> parent, Optional<ContextAwarePredicate> partner, Optional<ContextAwarePredicate> child) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337343_ -> p_337343_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("parent").forGetter(TriggerInstance::parent), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("partner").forGetter(TriggerInstance::partner), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("child").forGetter(TriggerInstance::child)).apply((Applicative)p_337343_, TriggerInstance::new));

        public static Criterion<TriggerInstance> bredAnimals() {
            return CriteriaTriggers.BRED_ANIMALS.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> bredAnimals(EntityPredicate.Builder p_301285_) {
            return CriteriaTriggers.BRED_ANIMALS.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(EntityPredicate.wrap(p_301285_))));
        }

        public static Criterion<TriggerInstance> bredAnimals(Optional<EntityPredicate> p_301067_, Optional<EntityPredicate> p_301159_, Optional<EntityPredicate> p_301056_) {
            return CriteriaTriggers.BRED_ANIMALS.createCriterion(new TriggerInstance(Optional.empty(), EntityPredicate.wrap(p_301067_), EntityPredicate.wrap(p_301159_), EntityPredicate.wrap(p_301056_)));
        }

        public boolean matches(LootContext p_18676_, LootContext p_18677_, @Nullable LootContext p_18678_) {
            if (this.child.isPresent() && (p_18678_ == null || !this.child.get().matches(p_18678_))) {
                return false;
            }
            return TriggerInstance.matches(this.parent, p_18676_) && TriggerInstance.matches(this.partner, p_18677_) || TriggerInstance.matches(this.parent, p_18677_) && TriggerInstance.matches(this.partner, p_18676_);
        }

        private static boolean matches(Optional<ContextAwarePredicate> p_298925_, LootContext p_298317_) {
            return p_298925_.isEmpty() || p_298925_.get().matches(p_298317_);
        }

        @Override
        public void validate(CriterionValidator p_312663_) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(p_312663_);
            p_312663_.validateEntity(this.parent, "parent");
            p_312663_.validateEntity(this.partner, "partner");
            p_312663_.validateEntity(this.child, "child");
        }
    }
}

