/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.serialization.DataResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Pattern COPY_COUNTER_PATTERN = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final int MAX_FILE_NAME = 255;
    private static final Pattern RESERVED_WINDOWS_FILENAMES = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    private static final Pattern STRICT_PATH_SEGMENT_CHECK = Pattern.compile("[-._a-z0-9]+");

    public static String sanitizeName(String p_352262_) {
        for (char $$1 : SharedConstants.ILLEGAL_FILE_CHARACTERS) {
            p_352262_ = p_352262_.replace($$1, '_');
        }
        return p_352262_.replaceAll("[./\"]", "_");
    }

    public static String findAvailableName(Path p_133731_, String p_133732_, String p_133733_) throws IOException {
        if (!FileUtil.isPathPartPortable((String)(p_133732_ = FileUtil.sanitizeName((String)p_133732_)))) {
            p_133732_ = "_" + (String)p_133732_ + "_";
        }
        Matcher $$3 = COPY_COUNTER_PATTERN.matcher((CharSequence)p_133732_);
        int $$4 = 0;
        if ($$3.matches()) {
            p_133732_ = $$3.group("name");
            $$4 = Integer.parseInt($$3.group("count"));
        }
        if (((String)p_133732_).length() > 255 - p_133733_.length()) {
            p_133732_ = ((String)p_133732_).substring(0, 255 - p_133733_.length());
        }
        while (true) {
            Object $$5 = p_133732_;
            if ($$4 != 0) {
                String $$6 = " (" + $$4 + ")";
                int $$7 = 255 - $$6.length();
                if (((String)$$5).length() > $$7) {
                    $$5 = ((String)$$5).substring(0, $$7);
                }
                $$5 = (String)$$5 + $$6;
            }
            $$5 = (String)$$5 + p_133733_;
            Path $$8 = p_133731_.resolve((String)$$5);
            try {
                Path $$9 = Files.createDirectory($$8, new FileAttribute[0]);
                Files.deleteIfExists($$9);
                return p_133731_.relativize($$9).toString();
            }
            catch (FileAlreadyExistsException $$10) {
                ++$$4;
                continue;
            }
            break;
        }
    }

    public static boolean isPathNormalized(Path p_133729_) {
        Path $$1 = p_133729_.normalize();
        return $$1.equals(p_133729_);
    }

    public static boolean isPathPortable(Path p_133735_) {
        for (Path $$1 : p_133735_) {
            if (FileUtil.isPathPartPortable($$1.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isPathPartPortable(String p_428321_) {
        return !RESERVED_WINDOWS_FILENAMES.matcher(p_428321_).matches();
    }

    public static Path createPathToResource(Path p_133737_, String p_133738_, String p_133739_) {
        String $$3 = p_133738_ + p_133739_;
        Path $$4 = Paths.get($$3, new String[0]);
        if ($$4.endsWith(p_133739_)) {
            throw new InvalidPathException($$3, "empty resource name");
        }
        return p_133737_.resolve($$4);
    }

    public static String getFullResourcePath(String p_179923_) {
        return FilenameUtils.getFullPath((String)p_179923_).replace(File.separator, "/");
    }

    public static String normalizeResourcePath(String p_179925_) {
        return FilenameUtils.normalize((String)p_179925_).replace(File.separator, "/");
    }

    public static DataResult<List<String>> decomposePath(String p_248866_) {
        int $$1 = p_248866_.indexOf(47);
        if ($$1 == -1) {
            return switch (p_248866_) {
                case "", ".", ".." -> DataResult.error(() -> "Invalid path '" + p_248866_ + "'");
                default -> !FileUtil.isValidStrictPathSegment(p_248866_) ? DataResult.error(() -> "Invalid path '" + p_248866_ + "'") : DataResult.success(List.of(p_248866_));
            };
        }
        ArrayList<String> $$2 = new ArrayList<String>();
        int $$3 = 0;
        boolean $$4 = false;
        while (true) {
            String $$5;
            switch ($$5 = p_248866_.substring($$3, $$1)) {
                case "": 
                case ".": 
                case "..": {
                    return DataResult.error(() -> "Invalid segment '" + $$5 + "' in path '" + p_248866_ + "'");
                }
            }
            if (!FileUtil.isValidStrictPathSegment($$5)) {
                return DataResult.error(() -> "Invalid segment '" + $$5 + "' in path '" + p_248866_ + "'");
            }
            $$2.add($$5);
            if ($$4) {
                return DataResult.success($$2);
            }
            $$3 = $$1 + 1;
            if (($$1 = p_248866_.indexOf(47, $$3)) != -1) continue;
            $$1 = p_248866_.length();
            $$4 = true;
        }
    }

    public static Path resolvePath(Path p_251522_, List<String> p_251495_) {
        int $$2 = p_251495_.size();
        return switch ($$2) {
            case 0 -> p_251522_;
            case 1 -> p_251522_.resolve(p_251495_.get(0));
            default -> {
                String[] $$3 = new String[$$2 - 1];
                for (int $$4 = 1; $$4 < $$2; ++$$4) {
                    $$3[$$4 - 1] = p_251495_.get($$4);
                }
                yield p_251522_.resolve(p_251522_.getFileSystem().getPath(p_251495_.get(0), $$3));
            }
        };
    }

    public static boolean isValidStrictPathSegment(String p_249814_) {
        return STRICT_PATH_SEGMENT_CHECK.matcher(p_249814_).matches();
    }

    public static void validatePath(String ... p_249502_) {
        if (p_249502_.length == 0) {
            throw new IllegalArgumentException("Path must have at least one element");
        }
        for (String $$1 : p_249502_) {
            if (!$$1.equals("..") && !$$1.equals(".") && FileUtil.isValidStrictPathSegment($$1)) continue;
            throw new IllegalArgumentException("Illegal segment " + $$1 + " in path " + Arrays.toString(p_249502_));
        }
    }

    public static void createDirectoriesSafe(Path p_259902_) throws IOException {
        Files.createDirectories(Files.exists(p_259902_, new LinkOption[0]) ? p_259902_.toRealPath(new LinkOption[0]) : p_259902_, new FileAttribute[0]);
    }
}

