/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util.task;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.util.task.LongRunningTask;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class DownloadTask
extends LongRunningTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component TITLE = Component.translatable("mco.download.preparing");
    private final long realmId;
    private final int slot;
    private final Screen lastScreen;
    private final String downloadName;

    public DownloadTask(long p_90320_, int p_90321_, String p_90322_, Screen p_90323_) {
        this.realmId = p_90320_;
        this.slot = p_90321_;
        this.lastScreen = p_90323_;
        this.downloadName = p_90322_;
    }

    @Override
    public void run() {
        RealmsClient $$0 = RealmsClient.getOrCreate();
        for (int $$1 = 0; $$1 < 25; ++$$1) {
            try {
                if (this.aborted()) {
                    return;
                }
                WorldDownload $$2 = $$0.requestDownloadInfo(this.realmId, this.slot);
                DownloadTask.pause(1L);
                if (this.aborted()) {
                    return;
                }
                DownloadTask.setScreen(new RealmsDownloadLatestWorldScreen(this.lastScreen, $$2, this.downloadName, p_90325_ -> {}));
                return;
            }
            catch (RetryCallException $$3) {
                if (this.aborted()) {
                    return;
                }
                DownloadTask.pause($$3.delaySeconds);
                continue;
            }
            catch (RealmsServiceException $$4) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't download world data", (Throwable)$$4);
                DownloadTask.setScreen(new RealmsGenericErrorScreen($$4, this.lastScreen));
                return;
            }
            catch (Exception $$5) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't download world data", (Throwable)$$5);
                this.error($$5);
                return;
            }
        }
    }

    @Override
    public Component getTitle() {
        return TITLE;
    }
}

