/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.mojang.realmsclient.dto.RealmsRegion;
import com.mojang.realmsclient.dto.RegionSelectionPreference;
import com.mojang.realmsclient.dto.ServiceQuality;
import com.mojang.realmsclient.gui.screens.configuration.RealmsSettingsTab;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class RealmsPreferredRegionSelectionScreen
extends Screen {
    private static final Component REGION_SELECTION_LABEL = Component.translatable("mco.configure.world.region_preference.title");
    private static final int SPACING = 8;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    private final Screen parent;
    private final BiConsumer<RegionSelectionPreference, RealmsRegion> applySettings;
    final Map<RealmsRegion, ServiceQuality> regionServiceQuality;
    @Nullable
    private RegionSelectionList list;
    RealmsSettingsTab.RegionSelection selection;
    @Nullable
    private Button doneButton;

    public RealmsPreferredRegionSelectionScreen(Screen p_419844_, BiConsumer<RegionSelectionPreference, RealmsRegion> p_420012_, Map<RealmsRegion, ServiceQuality> p_420025_, RealmsSettingsTab.RegionSelection p_419683_) {
        super(REGION_SELECTION_LABEL);
        this.parent = p_419844_;
        this.applySettings = p_420012_;
        this.regionServiceQuality = p_420025_;
        this.selection = p_419683_;
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    protected void init() {
        LinearLayout $$0 = this.layout.addToHeader(LinearLayout.vertical().spacing(8));
        $$0.defaultCellSetting().alignHorizontallyCenter();
        $$0.addChild(new StringWidget(this.getTitle(), this.font));
        this.list = this.layout.addToContents(new RegionSelectionList());
        LinearLayout $$1 = this.layout.addToFooter(LinearLayout.horizontal().spacing(8));
        this.doneButton = $$1.addChild(Button.builder(CommonComponents.GUI_DONE, p_425124_ -> {
            this.applySettings.accept(this.selection.preference(), this.selection.region());
            this.onClose();
        }).build());
        $$1.addChild(Button.builder(CommonComponents.GUI_CANCEL, p_419746_ -> this.onClose()).build());
        this.list.setSelected((RegionSelectionList.Entry)this.list.children().stream().filter(p_419913_ -> Objects.equals(p_419913_.regionSelection, this.selection)).findFirst().orElse(null));
        this.layout.visitWidgets(p_419955_ -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(p_419955_);
        });
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        this.list.updateSize(this.width, this.layout);
    }

    void updateButtonValidity() {
        this.doneButton.active = this.list.getSelected() != null;
    }

    class RegionSelectionList
    extends ObjectSelectionList<Entry> {
        RegionSelectionList() {
            super(RealmsPreferredRegionSelectionScreen.this.minecraft, RealmsPreferredRegionSelectionScreen.this.width, RealmsPreferredRegionSelectionScreen.this.height - 77, 40, 16);
            this.addEntry(new Entry(RegionSelectionPreference.AUTOMATIC_PLAYER, null));
            this.addEntry(new Entry(RegionSelectionPreference.AUTOMATIC_OWNER, null));
            RealmsPreferredRegionSelectionScreen.this.regionServiceQuality.keySet().stream().map(p_425125_ -> new Entry(RegionSelectionPreference.MANUAL, (RealmsRegion)((Object)p_425125_))).forEach(p_419732_ -> this.addEntry(p_419732_));
        }

        @Override
        public void setSelected(@Nullable Entry p_419729_) {
            super.setSelected(p_419729_);
            if (p_419729_ != null) {
                RealmsPreferredRegionSelectionScreen.this.selection = p_419729_.regionSelection;
            }
            RealmsPreferredRegionSelectionScreen.this.updateButtonValidity();
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final RealmsSettingsTab.RegionSelection regionSelection;
            private final Component name;

            public Entry(@Nullable RegionSelectionPreference p_426132_, RealmsRegion p_420055_) {
                this(new RealmsSettingsTab.RegionSelection(p_426132_, p_420055_));
            }

            public Entry(RealmsSettingsTab.RegionSelection p_420050_) {
                this.regionSelection = p_420050_;
                this.name = p_420050_.preference() == RegionSelectionPreference.MANUAL ? (p_420050_.region() != null ? Component.translatable(p_420050_.region().translationKey) : Component.empty()) : Component.translatable(p_420050_.preference().translationKey);
            }

            @Override
            public Component getNarration() {
                return Component.translatable("narrator.select", this.name);
            }

            @Override
            public void render(GuiGraphics p_419543_, int p_419601_, int p_419551_, int p_419789_, int p_419492_, int p_419930_, int p_419642_, int p_419914_, boolean p_419487_, float p_420047_) {
                p_419543_.drawString(RealmsPreferredRegionSelectionScreen.this.font, this.name, p_419789_ + 5, p_419551_ + 2, -1);
                if (this.regionSelection.region() != null && RealmsPreferredRegionSelectionScreen.this.regionServiceQuality.containsKey((Object)this.regionSelection.region())) {
                    ServiceQuality $$10 = RealmsPreferredRegionSelectionScreen.this.regionServiceQuality.getOrDefault((Object)this.regionSelection.region(), ServiceQuality.UNKNOWN);
                    p_419543_.blitSprite(RenderPipelines.GUI_TEXTURED, $$10.getIcon(), p_419789_ + p_419492_ - 18, p_419551_ + 2, 10, 8);
                }
            }

            @Override
            public boolean mouseClicked(double p_419613_, double p_419852_, int p_419990_) {
                RegionSelectionList.this.setSelected(this);
                return super.mouseClicked(p_419613_, p_419852_, p_419990_);
            }
        }
    }
}

