/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.StringUtil;

public class RealmsInviteScreen
extends RealmsScreen {
    private static final Component TITLE = Component.translatable("mco.configure.world.buttons.invite");
    private static final Component NAME_LABEL = Component.translatable("mco.configure.world.invite.profile.name").withColor(-6250336);
    private static final Component INVITING_PLAYER_TEXT = Component.translatable("mco.configure.world.players.inviting").withColor(-6250336);
    private static final Component NO_SUCH_PLAYER_ERROR_TEXT = Component.translatable("mco.configure.world.players.error").withColor(-65536);
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    @Nullable
    private EditBox profileName;
    @Nullable
    private Button inviteButton;
    private final RealmsServer serverData;
    private final RealmsConfigureWorldScreen configureScreen;
    @Nullable
    private Component message;

    public RealmsInviteScreen(RealmsConfigureWorldScreen p_420015_, RealmsServer p_419560_) {
        super(TITLE);
        this.configureScreen = p_420015_;
        this.serverData = p_419560_;
    }

    @Override
    public void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        LinearLayout $$0 = this.layout.addToContents(LinearLayout.vertical().spacing(8));
        this.profileName = new EditBox(this.minecraft.font, 200, 20, Component.translatable("mco.configure.world.invite.profile.name"));
        $$0.addChild(CommonLayouts.labeledElement(this.font, this.profileName, NAME_LABEL));
        this.inviteButton = $$0.addChild(Button.builder(TITLE, p_419525_ -> this.onInvite()).width(200).build());
        this.layout.addToFooter(Button.builder(CommonComponents.GUI_BACK, p_420065_ -> this.onClose()).width(200).build());
        this.layout.visitWidgets(p_419675_ -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(p_419675_);
        });
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    @Override
    protected void setInitialFocus() {
        if (this.profileName != null) {
            this.setInitialFocus(this.profileName);
        }
    }

    private void onInvite() {
        if (this.inviteButton == null || this.profileName == null) {
            return;
        }
        if (StringUtil.isBlank(this.profileName.getValue())) {
            this.showMessage(NO_SUCH_PLAYER_ERROR_TEXT);
            return;
        }
        long $$0 = this.serverData.id;
        String $$1 = this.profileName.getValue().trim();
        this.inviteButton.active = false;
        this.profileName.setEditable(false);
        this.showMessage(INVITING_PLAYER_TEXT);
        CompletableFuture.supplyAsync(() -> this.configureScreen.invitePlayer($$0, $$1), Util.ioPool()).thenAcceptAsync(p_419916_ -> {
            if (p_419916_.booleanValue()) {
                this.minecraft.setScreen(this.configureScreen);
            } else {
                this.showMessage(NO_SUCH_PLAYER_ERROR_TEXT);
            }
            this.profileName.setEditable(true);
            this.inviteButton.active = true;
        }, this.screenExecutor);
    }

    private void showMessage(Component p_419609_) {
        this.message = p_419609_;
        this.minecraft.getNarrator().saySystemNow(p_419609_);
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.configureScreen);
    }

    @Override
    public void render(GuiGraphics p_419648_, int p_419872_, int p_419481_, float p_419581_) {
        super.render(p_419648_, p_419872_, p_419481_, p_419581_);
        if (this.message != null && this.inviteButton != null) {
            p_419648_.drawCenteredString(this.font, this.message, this.width / 2, this.inviteButton.getY() + this.inviteButton.getHeight() + 8, -1);
        }
    }
}

