/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.client.RealmsError;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.PreferredRegionsDto;
import com.mojang.realmsclient.dto.RealmsRegion;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsSlot;
import com.mojang.realmsclient.dto.RegionDataDto;
import com.mojang.realmsclient.dto.RegionSelectionPreference;
import com.mojang.realmsclient.dto.RegionSelectionPreferenceDto;
import com.mojang.realmsclient.dto.ServiceQuality;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigurationTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsPlayersTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsSettingsTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsSubscriptionTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsWorldsTab;
import com.mojang.realmsclient.util.RealmsUtil;
import com.mojang.realmsclient.util.task.CloseServerTask;
import com.mojang.realmsclient.util.task.OpenServerTask;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.LoadingTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.StringUtil;
import org.slf4j.Logger;

public class RealmsConfigureWorldScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component PLAY_TEXT = Component.translatable("mco.selectServer.play");
    private final RealmsMainScreen lastScreen;
    @Nullable
    private RealmsServer serverData;
    @Nullable
    private PreferredRegionsDto regions;
    private final Map<RealmsRegion, ServiceQuality> regionServiceQuality = new LinkedHashMap<RealmsRegion, ServiceQuality>();
    private final long serverId;
    private boolean stateChanged;
    private final TabManager tabManager = new TabManager(p_419553_ -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(p_419553_);
    }, p_419490_ -> this.removeWidget((GuiEventListener)p_419490_), this::onTabSelected, this::onTabDeselected);
    @Nullable
    private Button playButton;
    @Nullable
    private TabNavigationBar tabNavigationBar;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);

    public RealmsConfigureWorldScreen(RealmsMainScreen p_427298_, long p_427446_, @Nullable RealmsServer p_427282_, @Nullable PreferredRegionsDto p_427395_) {
        super(Component.empty());
        this.lastScreen = p_427298_;
        this.serverId = p_427446_;
        this.serverData = p_427282_;
        this.regions = p_427395_;
    }

    public RealmsConfigureWorldScreen(RealmsMainScreen p_420068_, long p_419727_) {
        this(p_420068_, p_419727_, null, null);
    }

    @Override
    public void init() {
        if (this.serverData == null) {
            this.fetchServerData(this.serverId);
        }
        if (this.regions == null) {
            this.fetchRegionData();
        }
        MutableComponent $$0 = Component.translatable("mco.configure.world.loading");
        this.tabNavigationBar = TabNavigationBar.builder(this.tabManager, this.width).addTabs(new LoadingTab(this.getFont(), RealmsWorldsTab.TITLE, $$0), new LoadingTab(this.getFont(), RealmsPlayersTab.TITLE, $$0), new LoadingTab(this.getFont(), RealmsSubscriptionTab.TITLE, $$0), new LoadingTab(this.getFont(), RealmsSettingsTab.TITLE, $$0)).build();
        this.addRenderableWidget(this.tabNavigationBar);
        LinearLayout $$1 = this.layout.addToFooter(LinearLayout.horizontal().spacing(8));
        this.playButton = $$1.addChild(Button.builder(PLAY_TEXT, p_419811_ -> {
            this.onClose();
            RealmsMainScreen.play(this.serverData, this);
        }).width(150).build());
        this.playButton.active = false;
        $$1.addChild(Button.builder(CommonComponents.GUI_BACK, p_419967_ -> this.onClose()).build());
        this.layout.visitWidgets(p_419870_ -> {
            p_419870_.setTabOrderGroup(1);
            this.addRenderableWidget(p_419870_);
        });
        this.tabNavigationBar.selectTab(0, false);
        this.repositionElements();
        if (this.serverData != null && this.regions != null) {
            this.onRealmsDataFetched();
        }
    }

    private void onTabSelected(Tab p_419780_) {
        if (this.serverData != null && p_419780_ instanceof RealmsConfigurationTab) {
            RealmsConfigurationTab $$1 = (RealmsConfigurationTab)((Object)p_419780_);
            $$1.onSelected(this.serverData);
        }
    }

    private void onTabDeselected(Tab p_419627_) {
        if (this.serverData != null && p_419627_ instanceof RealmsConfigurationTab) {
            RealmsConfigurationTab $$1 = (RealmsConfigurationTab)((Object)p_419627_);
            $$1.onDeselected(this.serverData);
        }
    }

    public int getContentHeight() {
        return this.layout.getContentHeight();
    }

    public int getHeaderHeight() {
        return this.layout.getHeaderHeight();
    }

    public Screen getLastScreen() {
        return this.lastScreen;
    }

    public Screen createErrorScreen(RealmsServiceException p_428711_) {
        return new RealmsGenericErrorScreen(p_428711_, (Screen)this.lastScreen);
    }

    @Override
    public void repositionElements() {
        if (this.tabNavigationBar == null) {
            return;
        }
        this.tabNavigationBar.setWidth(this.width);
        this.tabNavigationBar.arrangeElements();
        int $$0 = this.tabNavigationBar.getRectangle().bottom();
        ScreenRectangle $$1 = new ScreenRectangle(0, $$0, this.width, this.height - this.layout.getFooterHeight() - $$0);
        this.tabManager.setTabArea($$1);
        this.layout.setHeaderHeight($$0);
        this.layout.arrangeElements();
    }

    private void updateButtonStates() {
        if (this.serverData != null && this.playButton != null) {
            this.playButton.active = this.serverData.shouldPlayButtonBeActive();
            if (!this.playButton.active && this.serverData.state == RealmsServer.State.CLOSED) {
                this.playButton.setTooltip(Tooltip.create(RealmsServer.WORLD_CLOSED_COMPONENT));
            }
        }
    }

    @Override
    public void render(GuiGraphics p_419682_, int p_419919_, int p_419524_, float p_419765_) {
        super.render(p_419682_, p_419919_, p_419524_, p_419765_);
        p_419682_.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - this.layout.getFooterHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
    }

    @Override
    public boolean keyPressed(int p_422583_, int p_421985_, int p_421505_) {
        if (this.tabNavigationBar.keyPressed(p_422583_)) {
            return true;
        }
        return super.keyPressed(p_422583_, p_421985_, p_421505_);
    }

    @Override
    protected void renderMenuBackground(GuiGraphics p_420036_) {
        p_420036_.blit(RenderPipelines.GUI_TEXTURED, CreateWorldScreen.TAB_HEADER_BACKGROUND, 0, 0, 0.0f, 0.0f, this.width, this.layout.getHeaderHeight(), 16, 16);
        this.renderMenuBackground(p_420036_, 0, this.layout.getHeaderHeight(), this.width, this.height);
    }

    @Override
    public void onClose() {
        Tab tab;
        if (this.serverData != null && (tab = this.tabManager.getCurrentTab()) instanceof RealmsConfigurationTab) {
            RealmsConfigurationTab $$0 = (RealmsConfigurationTab)((Object)tab);
            $$0.onDeselected(this.serverData);
        }
        this.minecraft.setScreen(this.lastScreen);
        if (this.stateChanged) {
            this.lastScreen.resetScreen();
        }
    }

    public void fetchRegionData() {
        RealmsUtil.supplyAsync(RealmsClient::getPreferredRegionSelections, RealmsUtil.openScreenAndLogOnFailure(this::createErrorScreen, "Couldn't get realms region data")).thenAcceptAsync(p_426844_ -> {
            this.regions = p_426844_;
            this.onRealmsDataFetched();
        }, (Executor)this.minecraft);
    }

    public void fetchServerData(long p_419600_) {
        RealmsUtil.supplyAsync(p_428649_ -> p_428649_.getOwnRealm(p_419600_), RealmsUtil.openScreenAndLogOnFailure(this::createErrorScreen, "Couldn't get own world")).thenAcceptAsync(p_419461_ -> {
            this.serverData = p_419461_;
            this.onRealmsDataFetched();
        }, (Executor)this.minecraft);
    }

    private void onRealmsDataFetched() {
        if (this.serverData == null || this.regions == null) {
            return;
        }
        this.regionServiceQuality.clear();
        for (RegionDataDto $$0 : this.regions.regionData()) {
            if ($$0.region() == RealmsRegion.INVALID_REGION) continue;
            this.regionServiceQuality.put($$0.region(), $$0.serviceQuality());
        }
        if (this.tabNavigationBar != null) {
            this.removeWidget(this.tabNavigationBar);
        }
        this.tabNavigationBar = TabNavigationBar.builder(this.tabManager, this.width).addTabs(new RealmsWorldsTab(this, Objects.requireNonNull(this.minecraft), this.serverData), new RealmsPlayersTab(this, this.minecraft, this.serverData), new RealmsSubscriptionTab(this, this.minecraft, this.serverData), new RealmsSettingsTab(this, this.minecraft, this.serverData, this.regionServiceQuality)).build();
        this.addRenderableWidget(this.tabNavigationBar);
        this.tabNavigationBar.selectTab(0, false);
        this.tabNavigationBar.setTabActiveState(3, !this.serverData.expired);
        if (this.serverData.expired) {
            this.tabNavigationBar.setTabTooltip(3, Tooltip.create(Component.translatable("mco.configure.world.settings.expired")));
        } else {
            this.tabNavigationBar.setTabTooltip(3, null);
        }
        this.updateButtonStates();
        this.repositionElements();
    }

    public void saveSlotSettings(RealmsSlot p_419771_) {
        RealmsSlot $$1 = this.serverData.slots.get(this.serverData.activeSlot);
        p_419771_.options.templateId = $$1.options.templateId;
        p_419771_.options.templateImage = $$1.options.templateImage;
        RealmsClient $$2 = RealmsClient.getOrCreate();
        try {
            if (this.serverData.activeSlot != p_419771_.slotId) {
                throw new RealmsServiceException(RealmsError.CustomError.configurationError());
            }
            $$2.updateSlot(this.serverData.id, p_419771_.slotId, p_419771_.options, p_419771_.settings);
            this.serverData.slots.put(this.serverData.activeSlot, p_419771_);
            if (p_419771_.options.gameMode != $$1.options.gameMode || p_419771_.isHardcore() != $$1.isHardcore()) {
                RealmsMainScreen.refreshServerList();
            }
            this.stateChanged();
        }
        catch (RealmsServiceException $$3) {
            LOGGER.error("Couldn't save slot settings", (Throwable)$$3);
            this.minecraft.setScreen(new RealmsGenericErrorScreen($$3, (Screen)this));
            return;
        }
        this.minecraft.setScreen(this);
    }

    public void saveSettings(String p_420072_, String p_419823_, RegionSelectionPreference p_426282_, @Nullable RealmsRegion p_419580_) {
        String $$4 = StringUtil.isBlank(p_419823_) ? "" : p_419823_;
        String $$5 = StringUtil.isBlank(p_420072_) ? "" : p_420072_;
        RealmsClient $$6 = RealmsClient.getOrCreate();
        try {
            RealmsSlot $$7 = this.serverData.slots.get(this.serverData.activeSlot);
            RealmsRegion $$8 = p_426282_ == RegionSelectionPreference.MANUAL ? p_419580_ : null;
            RegionSelectionPreferenceDto $$9 = new RegionSelectionPreferenceDto(p_426282_, $$8);
            $$6.updateConfiguration(this.serverData.id, $$5, $$4, $$9, $$7.slotId, $$7.options, $$7.settings);
            this.serverData.regionSelectionPreference = $$9;
            this.serverData.name = p_420072_;
            this.serverData.motd = $$4;
            this.stateChanged();
        }
        catch (RealmsServiceException $$10) {
            LOGGER.error("Couldn't save settings", (Throwable)$$10);
            this.minecraft.setScreen(new RealmsGenericErrorScreen($$10, (Screen)this));
            return;
        }
        this.minecraft.setScreen(this);
    }

    public void openTheWorld(boolean p_419983_) {
        RealmsConfigureWorldScreen $$1 = this.getNewScreenWithKnownData(this.serverData);
        this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(this.getNewScreen(), new OpenServerTask(this.serverData, $$1, p_419983_, this.minecraft)));
    }

    public void closeTheWorld() {
        RealmsConfigureWorldScreen $$0 = this.getNewScreenWithKnownData(this.serverData);
        this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(this.getNewScreen(), new CloseServerTask(this.serverData, $$0)));
    }

    public void stateChanged() {
        this.stateChanged = true;
        if (this.tabNavigationBar != null) {
            for (Tab $$0 : this.tabNavigationBar.getTabs()) {
                if (!($$0 instanceof RealmsConfigurationTab)) continue;
                RealmsConfigurationTab $$1 = (RealmsConfigurationTab)((Object)$$0);
                $$1.updateData(this.serverData);
            }
        }
    }

    public boolean invitePlayer(long p_419576_, String p_419508_) {
        RealmsClient $$2 = RealmsClient.getOrCreate();
        try {
            List<PlayerInfo> $$3 = $$2.invite(p_419576_, p_419508_);
            if (this.serverData != null) {
                this.serverData.players = $$3;
            } else {
                this.serverData = $$2.getOwnRealm(p_419576_);
            }
            this.stateChanged();
        }
        catch (RealmsServiceException $$4) {
            LOGGER.error("Couldn't invite user", (Throwable)$$4);
            return false;
        }
        return true;
    }

    public RealmsConfigureWorldScreen getNewScreen() {
        RealmsConfigureWorldScreen $$0 = new RealmsConfigureWorldScreen(this.lastScreen, this.serverId);
        $$0.stateChanged = this.stateChanged;
        return $$0;
    }

    public RealmsConfigureWorldScreen getNewScreenWithKnownData(RealmsServer p_427317_) {
        RealmsConfigureWorldScreen $$1 = new RealmsConfigureWorldScreen(this.lastScreen, this.serverId, p_427317_, this.regions);
        $$1.stateChanged = this.stateChanged;
        return $$1;
    }
}

