/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client.worldupload;

import com.mojang.realmsclient.client.worldupload.RealmsUploadCanceledException;
import com.mojang.realmsclient.client.worldupload.RealmsUploadTooLargeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class RealmsUploadWorldPacker {
    private static final long SIZE_LIMIT = 0x140000000L;
    private static final String WORLD_FOLDER_NAME = "world";
    private final BooleanSupplier isCanceled;
    private final Path directoryToPack;

    public static File pack(Path p_374057_, BooleanSupplier p_374422_) throws IOException {
        return new RealmsUploadWorldPacker(p_374057_, p_374422_).tarGzipArchive();
    }

    private RealmsUploadWorldPacker(Path p_374425_, BooleanSupplier p_374350_) {
        this.isCanceled = p_374350_;
        this.directoryToPack = p_374425_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File tarGzipArchive() throws IOException {
        try (TarArchiveOutputStream $$0 = null;){
            File $$1 = File.createTempFile("realms-upload-file", ".tar.gz");
            $$0 = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream($$1)));
            $$0.setLongFileMode(3);
            this.addFileToTarGz($$0, this.directoryToPack, WORLD_FOLDER_NAME, true);
            if (this.isCanceled.getAsBoolean()) {
                throw new RealmsUploadCanceledException();
            }
            $$0.finish();
            this.verifyBelowSizeLimit($$1.length());
            File file = $$1;
            return file;
        }
    }

    private void addFileToTarGz(TarArchiveOutputStream p_374061_, Path p_374216_, String p_374206_, boolean p_374384_) throws IOException {
        if (this.isCanceled.getAsBoolean()) {
            throw new RealmsUploadCanceledException();
        }
        this.verifyBelowSizeLimit(p_374061_.getBytesWritten());
        File $$4 = p_374216_.toFile();
        String $$5 = p_374384_ ? p_374206_ : p_374206_ + $$4.getName();
        TarArchiveEntry $$6 = new TarArchiveEntry($$4, $$5);
        p_374061_.putArchiveEntry($$6);
        if ($$4.isFile()) {
            try (FileInputStream $$7 = new FileInputStream($$4);){
                ((InputStream)$$7).transferTo((OutputStream)p_374061_);
            }
            p_374061_.closeArchiveEntry();
        } else {
            p_374061_.closeArchiveEntry();
            File[] $$8 = $$4.listFiles();
            if ($$8 != null) {
                for (File $$9 : $$8) {
                    this.addFileToTarGz(p_374061_, $$9.toPath(), $$5 + "/", false);
                }
            }
        }
    }

    private void verifyBelowSizeLimit(long p_374584_) {
        if (p_374584_ > 0x140000000L) {
            throw new RealmsUploadTooLargeException(0x140000000L);
        }
    }
}

