/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class RealmsAvailability {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static CompletableFuture<Result> future;

    public static CompletableFuture<Result> get() {
        if (future == null || RealmsAvailability.shouldRefresh(future)) {
            future = RealmsAvailability.check();
        }
        return future;
    }

    private static boolean shouldRefresh(CompletableFuture<Result> p_295124_) {
        Result $$1 = p_295124_.getNow(null);
        return $$1 != null && $$1.exception() != null;
    }

    private static CompletableFuture<Result> check() {
        User $$0 = Minecraft.getInstance().getUser();
        if ($$0.getType() != User.Type.MSA) {
            return CompletableFuture.completedFuture(new Result(Type.AUTHENTICATION_ERROR));
        }
        return CompletableFuture.supplyAsync(() -> {
            RealmsClient $$0 = RealmsClient.getOrCreate();
            try {
                if ($$0.clientCompatible() != RealmsClient.CompatibleVersionResponse.COMPATIBLE) {
                    return new Result(Type.INCOMPATIBLE_CLIENT);
                }
                if (!$$0.hasParentalConsent()) {
                    return new Result(Type.NEEDS_PARENTAL_CONSENT);
                }
                return new Result(Type.SUCCESS);
            }
            catch (RealmsServiceException $$1) {
                LOGGER.error("Couldn't connect to realms", (Throwable)$$1);
                if ($$1.realmsError.errorCode() == 401) {
                    return new Result(Type.AUTHENTICATION_ERROR);
                }
                return new Result($$1);
            }
        }, Util.ioPool());
    }

    public record Result(Type type, @Nullable RealmsServiceException exception) {
        public Result(Type p_294456_) {
            this(p_294456_, null);
        }

        public Result(RealmsServiceException p_294364_) {
            this(Type.UNEXPECTED_ERROR, p_294364_);
        }

        @Nullable
        public Screen createErrorScreen(Screen p_296406_) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> new RealmsClientOutdatedScreen(p_296406_);
                case 2 -> new RealmsParentalConsentScreen(p_296406_);
                case 3 -> new RealmsGenericErrorScreen(Component.translatable("mco.error.invalid.session.title"), Component.translatable("mco.error.invalid.session.message"), p_296406_);
                case 4 -> new RealmsGenericErrorScreen(Objects.requireNonNull(this.exception), p_296406_);
            };
        }
    }

    public static enum Type {
        SUCCESS,
        INCOMPATIBLE_CLIENT,
        NEEDS_PARENTAL_CONSENT,
        AUTHENTICATION_ERROR,
        UNEXPECTED_ERROR;

    }
}

