/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import java.util.Arrays;
import net.minecraft.Util;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

public enum SymmetricGroup3 {
    P123(0, 1, 2),
    P213(1, 0, 2),
    P132(0, 2, 1),
    P231(1, 2, 0),
    P312(2, 0, 1),
    P321(2, 1, 0);

    private final int[] permutation;
    private final Matrix3fc transformation;
    private static final int ORDER = 3;
    private static final SymmetricGroup3[][] CAYLEY_TABLE;

    private SymmetricGroup3(int p_109176_, int p_109177_, int p_109178_) {
        this.permutation = new int[]{p_109176_, p_109177_, p_109178_};
        Matrix3f $$3 = new Matrix3f().zero();
        $$3.set(this.permutation(0), 0, 1.0f);
        $$3.set(this.permutation(1), 1, 1.0f);
        $$3.set(this.permutation(2), 2, 1.0f);
        this.transformation = $$3;
    }

    public SymmetricGroup3 compose(SymmetricGroup3 p_109183_) {
        return CAYLEY_TABLE[this.ordinal()][p_109183_.ordinal()];
    }

    public int permutation(int p_109181_) {
        return this.permutation[p_109181_];
    }

    public Matrix3fc transformation() {
        return this.transformation;
    }

    static {
        CAYLEY_TABLE = Util.make(new SymmetricGroup3[SymmetricGroup3.values().length][SymmetricGroup3.values().length], p_109188_ -> {
            for (SymmetricGroup3 $$1 : SymmetricGroup3.values()) {
                for (SymmetricGroup3 $$2 : SymmetricGroup3.values()) {
                    SymmetricGroup3 $$5;
                    int[] $$3 = new int[3];
                    for (int $$4 = 0; $$4 < 3; ++$$4) {
                        $$3[$$4] = $$1.permutation[$$2.permutation[$$4]];
                    }
                    p_109188_[$$1.ordinal()][$$2.ordinal()] = $$5 = Arrays.stream(SymmetricGroup3.values()).filter(p_175577_ -> Arrays.equals(p_175577_.permutation, $$3)).findFirst().get();
                }
            }
        });
    }
}

