/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.textures;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;

@DontObfuscate
public abstract class GpuTexture
implements AutoCloseable {
    public static final int USAGE_COPY_DST = 1;
    public static final int USAGE_COPY_SRC = 2;
    public static final int USAGE_TEXTURE_BINDING = 4;
    public static final int USAGE_RENDER_ATTACHMENT = 8;
    public static final int USAGE_CUBEMAP_COMPATIBLE = 16;
    private final TextureFormat format;
    private final int width;
    private final int height;
    private final int depthOrLayers;
    private final int mipLevels;
    private final int usage;
    private final String label;
    protected AddressMode addressModeU = AddressMode.REPEAT;
    protected AddressMode addressModeV = AddressMode.REPEAT;
    protected FilterMode minFilter = FilterMode.NEAREST;
    protected FilterMode magFilter = FilterMode.LINEAR;
    protected boolean useMipmaps = true;

    public GpuTexture(int p_404771_, String p_405873_, TextureFormat p_405456_, int p_405638_, int p_404958_, int p_419943_, int p_423664_) {
        this.usage = p_404771_;
        this.label = p_405873_;
        this.format = p_405456_;
        this.width = p_405638_;
        this.height = p_404958_;
        this.depthOrLayers = p_419943_;
        this.mipLevels = p_423664_;
    }

    public int getWidth(int p_405560_) {
        return this.width >> p_405560_;
    }

    public int getHeight(int p_404653_) {
        return this.height >> p_404653_;
    }

    public int getDepthOrLayers() {
        return this.depthOrLayers;
    }

    public int getMipLevels() {
        return this.mipLevels;
    }

    public TextureFormat getFormat() {
        return this.format;
    }

    public int usage() {
        return this.usage;
    }

    public void setAddressMode(AddressMode p_404822_) {
        this.setAddressMode(p_404822_, p_404822_);
    }

    public void setAddressMode(AddressMode p_405632_, AddressMode p_404723_) {
        this.addressModeU = p_405632_;
        this.addressModeV = p_404723_;
    }

    public void setTextureFilter(FilterMode p_405811_, boolean p_405724_) {
        this.setTextureFilter(p_405811_, p_405811_, p_405724_);
    }

    public void setTextureFilter(FilterMode p_405337_, FilterMode p_405547_, boolean p_405592_) {
        this.minFilter = p_405337_;
        this.magFilter = p_405547_;
        this.setUseMipmaps(p_405592_);
    }

    public void setUseMipmaps(boolean p_416015_) {
        this.useMipmaps = p_416015_;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public abstract void close();

    public abstract boolean isClosed();
}

