/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDebugLabel;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.opengl.ARBVertexAttribBinding;
import org.lwjgl.opengl.GLCapabilities;

public abstract class VertexArrayCache {
    public static VertexArrayCache create(GLCapabilities p_410150_, GlDebugLabel p_410596_, Set<String> p_411102_) {
        if (p_410150_.GL_ARB_vertex_attrib_binding && GlDevice.USE_GL_ARB_vertex_attrib_binding) {
            p_411102_.add("GL_ARB_vertex_attrib_binding");
            return new Separate(p_410596_);
        }
        return new Emulated(p_410596_);
    }

    public abstract void bindVertexArray(VertexFormat var1, GlBuffer var2);

    static class Separate
    extends VertexArrayCache {
        private final Map<VertexFormat, VertexArray> cache = new HashMap<VertexFormat, VertexArray>();
        private final GlDebugLabel debugLabels;
        private final boolean needsMesaWorkaround;

        public Separate(GlDebugLabel p_410359_) {
            String $$1;
            this.debugLabels = p_410359_;
            this.needsMesaWorkaround = "Mesa".equals(GlStateManager._getString(7936)) ? ($$1 = GlStateManager._getString(7938)).contains("25.0.0") || $$1.contains("25.0.1") || $$1.contains("25.0.2") : false;
        }

        @Override
        public void bindVertexArray(VertexFormat p_410638_, GlBuffer p_410508_) {
            VertexArray $$2 = this.cache.get(p_410638_);
            if ($$2 == null) {
                int $$3 = GlStateManager._glGenVertexArrays();
                GlStateManager._glBindVertexArray($$3);
                List<VertexFormatElement> $$4 = p_410638_.getElements();
                for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                    VertexFormatElement $$6 = $$4.get($$5);
                    GlStateManager._enableVertexAttribArray($$5);
                    switch ($$6.usage()) {
                        case POSITION: 
                        case GENERIC: 
                        case UV: {
                            if ($$6.type() == VertexFormatElement.Type.FLOAT) {
                                ARBVertexAttribBinding.glVertexAttribFormat((int)$$5, (int)$$6.count(), (int)GlConst.toGl($$6.type()), (boolean)false, (int)p_410638_.getOffset($$6));
                                break;
                            }
                            ARBVertexAttribBinding.glVertexAttribIFormat((int)$$5, (int)$$6.count(), (int)GlConst.toGl($$6.type()), (int)p_410638_.getOffset($$6));
                            break;
                        }
                        case NORMAL: 
                        case COLOR: {
                            ARBVertexAttribBinding.glVertexAttribFormat((int)$$5, (int)$$6.count(), (int)GlConst.toGl($$6.type()), (boolean)true, (int)p_410638_.getOffset($$6));
                        }
                    }
                    ARBVertexAttribBinding.glVertexAttribBinding((int)$$5, (int)0);
                }
                ARBVertexAttribBinding.glBindVertexBuffer((int)0, (int)p_410508_.handle, (long)0L, (int)p_410638_.getVertexSize());
                VertexArray $$7 = new VertexArray($$3, p_410638_, p_410508_);
                this.debugLabels.applyLabel($$7);
                this.cache.put(p_410638_, $$7);
                return;
            }
            GlStateManager._glBindVertexArray($$2.id);
            if ($$2.lastVertexBuffer != p_410508_) {
                if (this.needsMesaWorkaround && $$2.lastVertexBuffer != null && $$2.lastVertexBuffer.handle == p_410508_.handle) {
                    ARBVertexAttribBinding.glBindVertexBuffer((int)0, (int)0, (long)0L, (int)0);
                }
                ARBVertexAttribBinding.glBindVertexBuffer((int)0, (int)p_410508_.handle, (long)0L, (int)p_410638_.getVertexSize());
                $$2.lastVertexBuffer = p_410508_;
            }
        }
    }

    static class Emulated
    extends VertexArrayCache {
        private final Map<VertexFormat, VertexArray> cache = new HashMap<VertexFormat, VertexArray>();
        private final GlDebugLabel debugLabels;

        public Emulated(GlDebugLabel p_409735_) {
            this.debugLabels = p_409735_;
        }

        @Override
        public void bindVertexArray(VertexFormat p_410490_, GlBuffer p_410612_) {
            VertexArray $$2 = this.cache.get(p_410490_);
            if ($$2 == null) {
                int $$3 = GlStateManager._glGenVertexArrays();
                GlStateManager._glBindVertexArray($$3);
                GlStateManager._glBindBuffer(34962, p_410612_.handle);
                Emulated.setupCombinedAttributes(p_410490_, true);
                VertexArray $$4 = new VertexArray($$3, p_410490_, p_410612_);
                this.debugLabels.applyLabel($$4);
                this.cache.put(p_410490_, $$4);
                return;
            }
            GlStateManager._glBindVertexArray($$2.id);
            if ($$2.lastVertexBuffer != p_410612_) {
                GlStateManager._glBindBuffer(34962, p_410612_.handle);
                $$2.lastVertexBuffer = p_410612_;
                Emulated.setupCombinedAttributes(p_410490_, false);
            }
        }

        private static void setupCombinedAttributes(VertexFormat p_409981_, boolean p_410588_) {
            int $$2 = p_409981_.getVertexSize();
            List<VertexFormatElement> $$3 = p_409981_.getElements();
            block4: for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
                VertexFormatElement $$5 = $$3.get($$4);
                if (p_410588_) {
                    GlStateManager._enableVertexAttribArray($$4);
                }
                switch ($$5.usage()) {
                    case POSITION: 
                    case GENERIC: 
                    case UV: {
                        if ($$5.type() == VertexFormatElement.Type.FLOAT) {
                            GlStateManager._vertexAttribPointer($$4, $$5.count(), GlConst.toGl($$5.type()), false, $$2, p_409981_.getOffset($$5));
                            continue block4;
                        }
                        GlStateManager._vertexAttribIPointer($$4, $$5.count(), GlConst.toGl($$5.type()), $$2, p_409981_.getOffset($$5));
                        continue block4;
                    }
                    case NORMAL: 
                    case COLOR: {
                        GlStateManager._vertexAttribPointer($$4, $$5.count(), GlConst.toGl($$5.type()), true, $$2, p_409981_.getOffset($$5));
                    }
                }
            }
        }
    }

    public static class VertexArray {
        final int id;
        final VertexFormat format;
        @Nullable
        GlBuffer lastVertexBuffer;

        VertexArray(int p_409990_, VertexFormat p_410774_, @Nullable GlBuffer p_410599_) {
            this.id = p_409990_;
            this.format = p_410774_;
            this.lastVertexBuffer = p_410599_;
        }
    }
}

