/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.DirectStateAccess;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import javax.annotation.Nullable;

public class GlTexture
extends GpuTexture {
    protected final int id;
    private final Int2IntMap fboCache = new Int2IntOpenHashMap();
    protected boolean closed;
    protected boolean modesDirty = true;
    private int views;

    protected GlTexture(int p_409690_, String p_410238_, TextureFormat p_410416_, int p_409866_, int p_410468_, int p_409791_, int p_419794_, int p_423590_) {
        super(p_409690_, p_410238_, p_410416_, p_409866_, p_410468_, p_409791_, p_419794_);
        this.id = p_423590_;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.views == 0) {
            this.destroyImmediately();
        }
    }

    private void destroyImmediately() {
        GlStateManager._deleteTexture(this.id);
        IntIterator intIterator = this.fboCache.values().iterator();
        while (intIterator.hasNext()) {
            int $$0 = (Integer)intIterator.next();
            GlStateManager._glDeleteFramebuffers($$0);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public int getFbo(DirectStateAccess p_412345_, @Nullable GpuTexture p_410364_) {
        int $$2 = p_410364_ == null ? 0 : ((GlTexture)p_410364_).id;
        return this.fboCache.computeIfAbsent($$2, p_411998_ -> {
            int $$3 = p_412345_.createFrameBufferObject();
            p_412345_.bindFrameBufferTextures($$3, this.id, $$2, 0, 0);
            return $$3;
        });
    }

    public void flushModeChanges(int p_423621_) {
        if (this.modesDirty) {
            GlStateManager._texParameter(p_423621_, 10242, GlConst.toGl(this.addressModeU));
            GlStateManager._texParameter(p_423621_, 10243, GlConst.toGl(this.addressModeV));
            switch (this.minFilter) {
                case NEAREST: {
                    GlStateManager._texParameter(p_423621_, 10241, this.useMipmaps ? 9986 : 9728);
                    break;
                }
                case LINEAR: {
                    GlStateManager._texParameter(p_423621_, 10241, this.useMipmaps ? 9987 : 9729);
                }
            }
            switch (this.magFilter) {
                case NEAREST: {
                    GlStateManager._texParameter(p_423621_, 10240, 9728);
                    break;
                }
                case LINEAR: {
                    GlStateManager._texParameter(p_423621_, 10240, 9729);
                }
            }
            this.modesDirty = false;
        }
    }

    public int glId() {
        return this.id;
    }

    @Override
    public void setAddressMode(AddressMode p_409820_, AddressMode p_409765_) {
        super.setAddressMode(p_409820_, p_409765_);
        this.modesDirty = true;
    }

    @Override
    public void setTextureFilter(FilterMode p_410846_, FilterMode p_409662_, boolean p_410630_) {
        super.setTextureFilter(p_410846_, p_409662_, p_410630_);
        this.modesDirty = true;
    }

    @Override
    public void setUseMipmaps(boolean p_416221_) {
        super.setUseMipmaps(p_416221_);
        this.modesDirty = true;
    }

    public void addViews() {
        ++this.views;
    }

    public void removeViews() {
        --this.views;
        if (this.closed && this.views == 0) {
            this.destroyImmediately();
        }
    }
}

