/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.GpuOutOfMemoryException;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.BufferStorage;
import com.mojang.blaze3d.opengl.DirectStateAccess;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlCommandEncoder;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDebug;
import com.mojang.blaze3d.opengl.GlDebugLabel;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlShaderModule;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.GlTextureView;
import com.mojang.blaze3d.opengl.VertexArrayCache;
import com.mojang.blaze3d.pipeline.CompiledRenderPipeline;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;

public class GlDevice
implements GpuDevice {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static boolean USE_GL_ARB_vertex_attrib_binding = true;
    protected static boolean USE_GL_KHR_debug = true;
    protected static boolean USE_GL_EXT_debug_label = true;
    protected static boolean USE_GL_ARB_debug_output = true;
    protected static boolean USE_GL_ARB_direct_state_access = true;
    protected static boolean USE_GL_ARB_buffer_storage = true;
    private final CommandEncoder encoder;
    @Nullable
    private final GlDebug debugLog;
    private final GlDebugLabel debugLabels;
    private final int maxSupportedTextureSize;
    private final DirectStateAccess directStateAccess;
    private final BiFunction<ResourceLocation, ShaderType, String> defaultShaderSource;
    private final Map<RenderPipeline, GlRenderPipeline> pipelineCache = new IdentityHashMap<RenderPipeline, GlRenderPipeline>();
    private final Map<ShaderCompilationKey, GlShaderModule> shaderCache = new HashMap<ShaderCompilationKey, GlShaderModule>();
    private final VertexArrayCache vertexArrayCache;
    private final BufferStorage bufferStorage;
    private final Set<String> enabledExtensions = new HashSet<String>();
    private final int uniformOffsetAlignment;

    public GlDevice(long p_410629_, int p_410525_, boolean p_409747_, BiFunction<ResourceLocation, ShaderType, String> p_410292_, boolean p_410647_) {
        GLFW.glfwMakeContextCurrent((long)p_410629_);
        GLCapabilities $$5 = GL.createCapabilities();
        int $$6 = GlDevice.getMaxSupportedTextureSize();
        GLFW.glfwSetWindowSizeLimits((long)p_410629_, (int)-1, (int)-1, (int)$$6, (int)$$6);
        this.debugLog = GlDebug.enableDebugCallback(p_410525_, p_409747_, this.enabledExtensions);
        this.debugLabels = GlDebugLabel.create($$5, p_410647_, this.enabledExtensions);
        this.vertexArrayCache = VertexArrayCache.create($$5, this.debugLabels, this.enabledExtensions);
        this.bufferStorage = BufferStorage.create($$5, this.enabledExtensions);
        this.directStateAccess = DirectStateAccess.create($$5, this.enabledExtensions);
        this.maxSupportedTextureSize = $$6;
        this.defaultShaderSource = p_410292_;
        this.encoder = new GlCommandEncoder(this);
        this.uniformOffsetAlignment = GL11.glGetInteger((int)35380);
        GL11.glEnable((int)34895);
    }

    public GlDebugLabel debugLabels() {
        return this.debugLabels;
    }

    @Override
    public CommandEncoder createCommandEncoder() {
        return this.encoder;
    }

    @Override
    public GpuTexture createTexture(@Nullable Supplier<String> p_419620_, int p_410354_, TextureFormat p_410264_, int p_410141_, int p_410230_, int p_419503_, int p_423479_) {
        return this.createTexture(this.debugLabels.exists() && p_419620_ != null ? p_419620_.get() : null, p_410354_, p_410264_, p_410141_, p_410230_, p_419503_, p_423479_);
    }

    @Override
    public GpuTexture createTexture(@Nullable String p_419622_, int p_410064_, TextureFormat p_409632_, int p_410837_, int p_410395_, int p_419883_, int p_423630_) {
        int $$14;
        int $$10;
        boolean $$7;
        if (p_423630_ < 1) {
            throw new IllegalArgumentException("mipLevels must be at least 1");
        }
        if (p_419883_ < 1) {
            throw new IllegalArgumentException("depthOrLayers must be at least 1");
        }
        boolean bl = $$7 = (p_410064_ & 0x10) != 0;
        if ($$7) {
            if (p_410837_ != p_410395_) {
                throw new IllegalArgumentException("Cubemap compatible textures must be square, but size is " + p_410837_ + "x" + p_410395_);
            }
            if (p_419883_ % 6 != 0) {
                throw new IllegalArgumentException("Cubemap compatible textures must have a layer count with a multiple of 6, was " + p_419883_);
            }
            if (p_419883_ > 6) {
                throw new UnsupportedOperationException("Array textures are not yet supported");
            }
        } else if (p_419883_ > 1) {
            throw new UnsupportedOperationException("Array or 3D textures are not yet supported");
        }
        GlStateManager.clearGlErrors();
        int $$8 = GlStateManager._genTexture();
        if (p_419622_ == null) {
            p_419622_ = String.valueOf($$8);
        }
        if ($$7) {
            GL11.glBindTexture((int)34067, (int)$$8);
            int $$9 = 34067;
        } else {
            GlStateManager._bindTexture($$8);
            $$10 = 3553;
        }
        GlStateManager._texParameter($$10, 33085, p_423630_ - 1);
        GlStateManager._texParameter($$10, 33082, 0);
        GlStateManager._texParameter($$10, 33083, p_423630_ - 1);
        if (p_409632_.hasDepthAspect()) {
            GlStateManager._texParameter($$10, 34892, 0);
        }
        if ($$7) {
            for (int $$11 : GlConst.CUBEMAP_TARGETS) {
                for (int $$12 = 0; $$12 < p_423630_; ++$$12) {
                    GlStateManager._texImage2D($$11, $$12, GlConst.toGlInternalId(p_409632_), p_410837_ >> $$12, p_410395_ >> $$12, 0, GlConst.toGlExternalId(p_409632_), GlConst.toGlType(p_409632_), null);
                }
            }
        } else {
            for (int $$13 = 0; $$13 < p_423630_; ++$$13) {
                GlStateManager._texImage2D($$10, $$13, GlConst.toGlInternalId(p_409632_), p_410837_ >> $$13, p_410395_ >> $$13, 0, GlConst.toGlExternalId(p_409632_), GlConst.toGlType(p_409632_), null);
            }
        }
        if (($$14 = GlStateManager._getError()) == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate texture of " + p_410837_ + "x" + p_410395_ + " for " + p_419622_);
        }
        if ($$14 != 0) {
            throw new IllegalStateException("OpenGL error " + $$14);
        }
        GlTexture $$15 = new GlTexture(p_410064_, p_419622_, p_409632_, p_410837_, p_410395_, p_419883_, p_423630_, $$8);
        this.debugLabels.applyLabel($$15);
        return $$15;
    }

    @Override
    public GpuTextureView createTextureView(GpuTexture p_423640_) {
        return this.createTextureView(p_423640_, 0, p_423640_.getMipLevels());
    }

    @Override
    public GpuTextureView createTextureView(GpuTexture p_423535_, int p_423686_, int p_423461_) {
        if (p_423535_.isClosed()) {
            throw new IllegalArgumentException("Can't create texture view with closed texture");
        }
        if (p_423686_ < 0 || p_423686_ + p_423461_ > p_423535_.getMipLevels()) {
            throw new IllegalArgumentException(p_423461_ + " mip levels starting from " + p_423686_ + " would be out of range for texture with only " + p_423535_.getMipLevels() + " mip levels");
        }
        return new GlTextureView((GlTexture)p_423535_, p_423686_, p_423461_);
    }

    @Override
    public GpuBuffer createBuffer(@Nullable Supplier<String> p_409705_, int p_410348_, int p_418515_) {
        if (p_418515_ <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        GlStateManager.clearGlErrors();
        GlBuffer $$3 = this.bufferStorage.createBuffer(this.directStateAccess, p_409705_, p_410348_, p_418515_);
        int $$4 = GlStateManager._getError();
        if ($$4 == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate buffer of " + p_418515_ + " for " + String.valueOf(p_409705_));
        }
        if ($$4 != 0) {
            throw new IllegalStateException("OpenGL error " + $$4);
        }
        this.debugLabels.applyLabel($$3);
        return $$3;
    }

    @Override
    public GpuBuffer createBuffer(@Nullable Supplier<String> p_410492_, int p_418387_, ByteBuffer p_410794_) {
        if (!p_410794_.hasRemaining()) {
            throw new IllegalArgumentException("Buffer source must not be empty");
        }
        GlStateManager.clearGlErrors();
        long $$3 = p_410794_.remaining();
        GlBuffer $$4 = this.bufferStorage.createBuffer(this.directStateAccess, p_410492_, p_418387_, p_410794_);
        int $$5 = GlStateManager._getError();
        if ($$5 == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate buffer of " + $$3 + " for " + String.valueOf(p_410492_));
        }
        if ($$5 != 0) {
            throw new IllegalStateException("OpenGL error " + $$5);
        }
        this.debugLabels.applyLabel($$4);
        return $$4;
    }

    @Override
    public String getImplementationInformation() {
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return GlStateManager._getString(7937) + " GL version " + GlStateManager._getString(7938) + ", " + GlStateManager._getString(7936);
    }

    @Override
    public List<String> getLastDebugMessages() {
        return this.debugLog == null ? Collections.emptyList() : this.debugLog.getLastOpenGlDebugMessages();
    }

    @Override
    public boolean isDebuggingEnabled() {
        return this.debugLog != null;
    }

    @Override
    public String getRenderer() {
        return GlStateManager._getString(7937);
    }

    @Override
    public String getVendor() {
        return GlStateManager._getString(7936);
    }

    @Override
    public String getBackendName() {
        return "OpenGL";
    }

    @Override
    public String getVersion() {
        return GlStateManager._getString(7938);
    }

    private static int getMaxSupportedTextureSize() {
        int $$0 = GlStateManager._getInteger(3379);
        for (int $$1 = Math.max(32768, $$0); $$1 >= 1024; $$1 >>= 1) {
            GlStateManager._texImage2D(32868, 0, 6408, $$1, $$1, 0, 6408, 5121, null);
            int $$2 = GlStateManager._getTexLevelParameter(32868, 0, 4096);
            if ($$2 == 0) continue;
            return $$1;
        }
        int $$3 = Math.max($$0, 1024);
        LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)$$3);
        return $$3;
    }

    @Override
    public int getMaxTextureSize() {
        return this.maxSupportedTextureSize;
    }

    @Override
    public int getUniformOffsetAlignment() {
        return this.uniformOffsetAlignment;
    }

    @Override
    public void clearPipelineCache() {
        for (GlRenderPipeline $$0 : this.pipelineCache.values()) {
            if ($$0.program() == GlProgram.INVALID_PROGRAM) continue;
            $$0.program().close();
        }
        this.pipelineCache.clear();
        for (GlShaderModule $$1 : this.shaderCache.values()) {
            if ($$1 == GlShaderModule.INVALID_SHADER) continue;
            $$1.close();
        }
        this.shaderCache.clear();
        String $$2 = GlStateManager._getString(7937);
        if ($$2.contains("AMD")) {
            GlDevice.amdDummyShaderWorkaround();
        }
    }

    private static void amdDummyShaderWorkaround() {
        int $$0 = GlStateManager.glCreateShader(35633);
        GlStateManager.glShaderSource($$0, "#version 150\nvoid main() {\n    gl_Position = vec4(0.0);\n}\n");
        GlStateManager.glCompileShader($$0);
        int $$1 = GlStateManager.glCreateShader(35632);
        GlStateManager.glShaderSource($$1, "#version 150\nlayout(std140) uniform Dummy {\n    float Value;\n};\nout vec4 fragColor;\nvoid main() {\n    fragColor = vec4(0.0);\n}\n");
        GlStateManager.glCompileShader($$1);
        int $$2 = GlStateManager.glCreateProgram();
        GlStateManager.glAttachShader($$2, $$0);
        GlStateManager.glAttachShader($$2, $$1);
        GlStateManager.glLinkProgram($$2);
        GL31.glGetUniformBlockIndex((int)$$2, (CharSequence)"Dummy");
        GlStateManager.glDeleteShader($$0);
        GlStateManager.glDeleteShader($$1);
        GlStateManager.glDeleteProgram($$2);
    }

    @Override
    public List<String> getEnabledExtensions() {
        return new ArrayList<String>(this.enabledExtensions);
    }

    @Override
    public void close() {
        this.clearPipelineCache();
    }

    public DirectStateAccess directStateAccess() {
        return this.directStateAccess;
    }

    protected GlRenderPipeline getOrCompilePipeline(RenderPipeline p_410397_) {
        return this.pipelineCache.computeIfAbsent(p_410397_, p_410866_ -> this.compilePipeline(p_410397_, this.defaultShaderSource));
    }

    protected GlShaderModule getOrCompileShader(ResourceLocation p_410881_, ShaderType p_409876_, ShaderDefines p_410398_, BiFunction<ResourceLocation, ShaderType, String> p_410158_) {
        ShaderCompilationKey $$4 = new ShaderCompilationKey(p_410881_, p_409876_, p_410398_);
        return this.shaderCache.computeIfAbsent($$4, p_410725_ -> this.compileShader($$4, p_410158_));
    }

    @Override
    public GlRenderPipeline precompilePipeline(RenderPipeline p_410489_, @Nullable BiFunction<ResourceLocation, ShaderType, String> p_410134_) {
        BiFunction<ResourceLocation, ShaderType, String> $$2 = p_410134_ == null ? this.defaultShaderSource : p_410134_;
        return this.pipelineCache.computeIfAbsent(p_410489_, p_410619_ -> this.compilePipeline(p_410489_, $$2));
    }

    private GlShaderModule compileShader(ShaderCompilationKey p_410649_, BiFunction<ResourceLocation, ShaderType, String> p_409708_) {
        String $$2 = p_409708_.apply(p_410649_.id, p_410649_.type);
        if ($$2 == null) {
            LOGGER.error("Couldn't find source for {} shader ({})", (Object)p_410649_.type, (Object)p_410649_.id);
            return GlShaderModule.INVALID_SHADER;
        }
        String $$3 = GlslPreprocessor.injectDefines($$2, p_410649_.defines);
        int $$4 = GlStateManager.glCreateShader(GlConst.toGl(p_410649_.type));
        GlStateManager.glShaderSource($$4, $$3);
        GlStateManager.glCompileShader($$4);
        if (GlStateManager.glGetShaderi($$4, 35713) == 0) {
            String $$5 = StringUtils.trim((String)GlStateManager.glGetShaderInfoLog($$4, 32768));
            LOGGER.error("Couldn't compile {} shader ({}): {}", new Object[]{p_410649_.type.getName(), p_410649_.id, $$5});
            return GlShaderModule.INVALID_SHADER;
        }
        GlShaderModule $$6 = new GlShaderModule($$4, p_410649_.id, p_410649_.type);
        this.debugLabels.applyLabel($$6);
        return $$6;
    }

    /*
     * WARNING - void declaration
     */
    private GlRenderPipeline compilePipeline(RenderPipeline p_409588_, BiFunction<ResourceLocation, ShaderType, String> p_410709_) {
        void $$6;
        GlShaderModule $$2 = this.getOrCompileShader(p_409588_.getVertexShader(), ShaderType.VERTEX, p_409588_.getShaderDefines(), p_410709_);
        GlShaderModule $$3 = this.getOrCompileShader(p_409588_.getFragmentShader(), ShaderType.FRAGMENT, p_409588_.getShaderDefines(), p_410709_);
        if ($$2 == GlShaderModule.INVALID_SHADER) {
            LOGGER.error("Couldn't compile pipeline {}: vertex shader {} was invalid", (Object)p_409588_.getLocation(), (Object)p_409588_.getVertexShader());
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        if ($$3 == GlShaderModule.INVALID_SHADER) {
            LOGGER.error("Couldn't compile pipeline {}: fragment shader {} was invalid", (Object)p_409588_.getLocation(), (Object)p_409588_.getFragmentShader());
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        try {
            GlProgram $$4 = GlProgram.link($$2, $$3, p_409588_.getVertexFormat(), p_409588_.getLocation().toString());
        }
        catch (ShaderManager.CompilationException $$5) {
            LOGGER.error("Couldn't compile program for pipeline {}: {}", (Object)p_409588_.getLocation(), (Object)$$5);
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        $$6.setupUniforms(p_409588_.getUniforms(), p_409588_.getSamplers());
        this.debugLabels.applyLabel((GlProgram)$$6);
        return new GlRenderPipeline(p_409588_, (GlProgram)$$6);
    }

    public VertexArrayCache vertexArrayCache() {
        return this.vertexArrayCache;
    }

    public BufferStorage getBufferStorage() {
        return this.bufferStorage;
    }

    public /* synthetic */ CompiledRenderPipeline precompilePipeline(RenderPipeline renderPipeline, @Nullable BiFunction biFunction) {
        return this.precompilePipeline(renderPipeline, biFunction);
    }

    record ShaderCompilationKey(ResourceLocation id, ShaderType type, ShaderDefines defines) {
        @Override
        public String toString() {
            String $$0 = String.valueOf(this.id) + " (" + String.valueOf((Object)this.type) + ")";
            if (!this.defines.isEmpty()) {
                return $$0 + " with " + String.valueOf(this.defines);
            }
            return $$0;
        }
    }
}

