/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.framegraph;

import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FrameGraphBuilder {
    private final List<InternalVirtualResource<?>> internalResources = new ArrayList();
    private final List<ExternalResource<?>> externalResources = new ArrayList();
    private final List<Pass> passes = new ArrayList<Pass>();

    public FramePass addPass(String p_362000_) {
        Pass $$1 = new Pass(this.passes.size(), p_362000_);
        this.passes.add($$1);
        return $$1;
    }

    public <T> ResourceHandle<T> importExternal(String p_363653_, T p_363574_) {
        ExternalResource<T> $$2 = new ExternalResource<T>(p_363653_, null, p_363574_);
        this.externalResources.add($$2);
        return $$2.handle;
    }

    public <T> ResourceHandle<T> createInternal(String p_364379_, ResourceDescriptor<T> p_360666_) {
        return this.createInternalResource((String)p_364379_, p_360666_, null).handle;
    }

    <T> InternalVirtualResource<T> createInternalResource(String p_362189_, ResourceDescriptor<T> p_361484_, @Nullable Pass p_363038_) {
        int $$3 = this.internalResources.size();
        InternalVirtualResource<T> $$4 = new InternalVirtualResource<T>($$3, p_362189_, p_363038_, p_361484_);
        this.internalResources.add($$4);
        return $$4;
    }

    public void execute(GraphicsResourceAllocator p_361151_) {
        this.execute(p_361151_, Inspector.NONE);
    }

    public void execute(GraphicsResourceAllocator p_362990_, Inspector p_363758_) {
        BitSet $$2 = this.identifyPassesToKeep();
        ArrayList<Pass> $$3 = new ArrayList<Pass>($$2.cardinality());
        BitSet $$4 = new BitSet(this.passes.size());
        for (Pass $$5 : this.passes) {
            this.resolvePassOrder($$5, $$2, $$4, $$3);
        }
        this.assignResourceLifetimes($$3);
        for (Pass $$6 : $$3) {
            for (InternalVirtualResource<?> $$7 : $$6.resourcesToAcquire) {
                p_363758_.acquireResource($$7.name);
                $$7.acquire(p_362990_);
            }
            p_363758_.beforeExecutePass($$6.name);
            $$6.task.run();
            p_363758_.afterExecutePass($$6.name);
            int $$8 = $$6.resourcesToRelease.nextSetBit(0);
            while ($$8 >= 0) {
                InternalVirtualResource<?> $$9 = this.internalResources.get($$8);
                p_363758_.releaseResource($$9.name);
                $$9.release(p_362990_);
                $$8 = $$6.resourcesToRelease.nextSetBit($$8 + 1);
            }
        }
    }

    private BitSet identifyPassesToKeep() {
        ArrayDeque<Pass> $$0 = new ArrayDeque<Pass>(this.passes.size());
        BitSet $$1 = new BitSet(this.passes.size());
        for (VirtualResource virtualResource : this.externalResources) {
            Pass $$3 = virtualResource.handle.createdBy;
            if ($$3 == null) continue;
            this.discoverAllRequiredPasses($$3, $$1, $$0);
        }
        for (Pass pass : this.passes) {
            if (!pass.disableCulling) continue;
            this.discoverAllRequiredPasses(pass, $$1, $$0);
        }
        return $$1;
    }

    private void discoverAllRequiredPasses(Pass p_362135_, BitSet p_361672_, Deque<Pass> p_363875_) {
        p_363875_.add(p_362135_);
        while (!p_363875_.isEmpty()) {
            Pass $$3 = p_363875_.poll();
            if (p_361672_.get($$3.id)) continue;
            p_361672_.set($$3.id);
            int $$4 = $$3.requiredPassIds.nextSetBit(0);
            while ($$4 >= 0) {
                p_363875_.add(this.passes.get($$4));
                $$4 = $$3.requiredPassIds.nextSetBit($$4 + 1);
            }
        }
    }

    private void resolvePassOrder(Pass p_361359_, BitSet p_362755_, BitSet p_362866_, List<Pass> p_365482_) {
        if (p_362866_.get(p_361359_.id)) {
            String $$4 = p_362866_.stream().mapToObj(p_361748_ -> this.passes.get((int)p_361748_).name).collect(Collectors.joining(", "));
            throw new IllegalStateException("Frame graph cycle detected between " + $$4);
        }
        if (!p_362755_.get(p_361359_.id)) {
            return;
        }
        p_362866_.set(p_361359_.id);
        p_362755_.clear(p_361359_.id);
        int $$5 = p_361359_.requiredPassIds.nextSetBit(0);
        while ($$5 >= 0) {
            this.resolvePassOrder(this.passes.get($$5), p_362755_, p_362866_, p_365482_);
            $$5 = p_361359_.requiredPassIds.nextSetBit($$5 + 1);
        }
        for (Handle<?> $$6 : p_361359_.writesFrom) {
            int $$7 = $$6.readBy.nextSetBit(0);
            while ($$7 >= 0) {
                if ($$7 != p_361359_.id) {
                    this.resolvePassOrder(this.passes.get($$7), p_362755_, p_362866_, p_365482_);
                }
                $$7 = $$6.readBy.nextSetBit($$7 + 1);
            }
        }
        p_365482_.add(p_361359_);
        p_362866_.clear(p_361359_.id);
    }

    private void assignResourceLifetimes(Collection<Pass> p_365083_) {
        Pass[] $$1 = new Pass[this.internalResources.size()];
        for (Pass $$2 : p_365083_) {
            int $$3 = $$2.requiredResourceIds.nextSetBit(0);
            while ($$3 >= 0) {
                InternalVirtualResource<?> $$4 = this.internalResources.get($$3);
                Pass $$5 = $$1[$$3];
                $$1[$$3] = $$2;
                if ($$5 == null) {
                    $$2.resourcesToAcquire.add($$4);
                } else {
                    $$5.resourcesToRelease.clear($$3);
                }
                $$2.resourcesToRelease.set($$3);
                $$3 = $$2.requiredResourceIds.nextSetBit($$3 + 1);
            }
        }
    }

    class Pass
    implements FramePass {
        final int id;
        final String name;
        final List<Handle<?>> writesFrom = new ArrayList();
        final BitSet requiredResourceIds = new BitSet();
        final BitSet requiredPassIds = new BitSet();
        Runnable task = () -> {};
        final List<InternalVirtualResource<?>> resourcesToAcquire = new ArrayList();
        final BitSet resourcesToRelease = new BitSet();
        boolean disableCulling;

        public Pass(int p_363679_, String p_362279_) {
            this.id = p_363679_;
            this.name = p_362279_;
        }

        private <T> void markResourceRequired(Handle<T> p_362265_) {
            VirtualResource virtualResource = p_362265_.holder;
            if (virtualResource instanceof InternalVirtualResource) {
                InternalVirtualResource $$1 = (InternalVirtualResource)virtualResource;
                this.requiredResourceIds.set($$1.id);
            }
        }

        private void markPassRequired(Pass p_361707_) {
            this.requiredPassIds.set(p_361707_.id);
        }

        @Override
        public <T> ResourceHandle<T> createsInternal(String p_363278_, ResourceDescriptor<T> p_363531_) {
            InternalVirtualResource<T> $$2 = FrameGraphBuilder.this.createInternalResource(p_363278_, p_363531_, this);
            this.requiredResourceIds.set($$2.id);
            return $$2.handle;
        }

        @Override
        public <T> void reads(ResourceHandle<T> p_363844_) {
            this._reads((Handle)p_363844_);
        }

        private <T> void _reads(Handle<T> p_360431_) {
            this.markResourceRequired(p_360431_);
            if (p_360431_.createdBy != null) {
                this.markPassRequired(p_360431_.createdBy);
            }
            p_360431_.readBy.set(this.id);
        }

        @Override
        public <T> ResourceHandle<T> readsAndWrites(ResourceHandle<T> p_363371_) {
            return this._readsAndWrites((Handle)p_363371_);
        }

        @Override
        public void requires(FramePass p_365196_) {
            this.requiredPassIds.set(((Pass)p_365196_).id);
        }

        @Override
        public void disableCulling() {
            this.disableCulling = true;
        }

        private <T> Handle<T> _readsAndWrites(Handle<T> p_364070_) {
            this.writesFrom.add(p_364070_);
            this._reads(p_364070_);
            return p_364070_.writeAndAlias(this);
        }

        @Override
        public void executes(Runnable p_360375_) {
            this.task = p_360375_;
        }

        public String toString() {
            return this.name;
        }
    }

    static class ExternalResource<T>
    extends VirtualResource<T> {
        private final T resource;

        public ExternalResource(String p_362541_, @Nullable Pass p_363193_, T p_360991_) {
            super(p_362541_, p_363193_);
            this.resource = p_360991_;
        }

        @Override
        public T get() {
            return this.resource;
        }
    }

    static class Handle<T>
    implements ResourceHandle<T> {
        final VirtualResource<T> holder;
        private final int version;
        @Nullable
        final Pass createdBy;
        final BitSet readBy = new BitSet();
        @Nullable
        private Handle<T> aliasedBy;

        Handle(VirtualResource<T> p_361124_, int p_362902_, @Nullable Pass p_361683_) {
            this.holder = p_361124_;
            this.version = p_362902_;
            this.createdBy = p_361683_;
        }

        @Override
        public T get() {
            return this.holder.get();
        }

        Handle<T> writeAndAlias(Pass p_365456_) {
            if (this.holder.handle != this) {
                throw new IllegalStateException("Handle " + String.valueOf(this) + " is no longer valid, as its contents were moved into " + String.valueOf(this.aliasedBy));
            }
            Handle<T> $$1 = new Handle<T>(this.holder, this.version + 1, p_365456_);
            this.holder.handle = $$1;
            this.aliasedBy = $$1;
            return $$1;
        }

        public String toString() {
            if (this.createdBy != null) {
                return String.valueOf(this.holder) + "#" + this.version + " (from " + String.valueOf(this.createdBy) + ")";
            }
            return String.valueOf(this.holder) + "#" + this.version;
        }
    }

    static class InternalVirtualResource<T>
    extends VirtualResource<T> {
        final int id;
        private final ResourceDescriptor<T> descriptor;
        @Nullable
        private T physicalResource;

        public InternalVirtualResource(int p_364397_, String p_361829_, @Nullable Pass p_364005_, ResourceDescriptor<T> p_364356_) {
            super(p_361829_, p_364005_);
            this.id = p_364397_;
            this.descriptor = p_364356_;
        }

        @Override
        public T get() {
            return Objects.requireNonNull(this.physicalResource, "Resource is not currently available");
        }

        public void acquire(GraphicsResourceAllocator p_363728_) {
            if (this.physicalResource != null) {
                throw new IllegalStateException("Tried to acquire physical resource, but it was already assigned");
            }
            this.physicalResource = p_363728_.acquire(this.descriptor);
        }

        public void release(GraphicsResourceAllocator p_362252_) {
            if (this.physicalResource == null) {
                throw new IllegalStateException("Tried to release physical resource that was not allocated");
            }
            p_362252_.release(this.descriptor, this.physicalResource);
            this.physicalResource = null;
        }
    }

    public static interface Inspector {
        public static final Inspector NONE = new Inspector(){};

        default public void acquireResource(String p_361310_) {
        }

        default public void releaseResource(String p_361496_) {
        }

        default public void beforeExecutePass(String p_362930_) {
        }

        default public void afterExecutePass(String p_363153_) {
        }
    }

    static abstract class VirtualResource<T> {
        public final String name;
        public Handle<T> handle;

        public VirtualResource(String p_361601_, @Nullable Pass p_361693_) {
            this.name = p_361601_;
            this.handle = new Handle(this, 0, p_361693_);
        }

        public abstract T get();

        public String toString() {
            return this.name;
        }
    }
}

