/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.jtracy.TracyClient;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.minecraft.client.renderer.RenderPipelines;

public class TracyFrameCapture
implements AutoCloseable {
    private static final int MAX_WIDTH = 320;
    private static final int MAX_HEIGHT = 180;
    private static final int BYTES_PER_PIXEL = 4;
    private int targetWidth;
    private int targetHeight;
    private int width = 320;
    private int height = 180;
    private GpuTexture frameBuffer;
    private GpuTextureView frameBufferView;
    private GpuBuffer pixelbuffer;
    private int lastCaptureDelay;
    private boolean capturedThisFrame;
    private Status status = Status.WAITING_FOR_CAPTURE;

    public TracyFrameCapture() {
        GpuDevice $$0 = RenderSystem.getDevice();
        this.frameBuffer = $$0.createTexture("Tracy Frame Capture", 10, TextureFormat.RGBA8, this.width, this.height, 1, 1);
        this.frameBufferView = $$0.createTextureView(this.frameBuffer);
        this.pixelbuffer = $$0.createBuffer(() -> "Tracy Frame Capture buffer", 9, this.width * this.height * 4);
    }

    private void resize(int p_372813_, int p_372948_) {
        float $$2 = (float)p_372813_ / (float)p_372948_;
        if (p_372813_ > 320) {
            p_372813_ = 320;
            p_372948_ = (int)(320.0f / $$2);
        }
        if (p_372948_ > 180) {
            p_372813_ = (int)(180.0f * $$2);
            p_372948_ = 180;
        }
        p_372813_ = p_372813_ / 4 * 4;
        p_372948_ = p_372948_ / 4 * 4;
        if (this.width != p_372813_ || this.height != p_372948_) {
            this.width = p_372813_;
            this.height = p_372948_;
            GpuDevice $$3 = RenderSystem.getDevice();
            this.frameBuffer.close();
            this.frameBuffer = $$3.createTexture("Tracy Frame Capture", 10, TextureFormat.RGBA8, p_372813_, p_372948_, 1, 1);
            this.frameBufferView.close();
            this.frameBufferView = $$3.createTextureView(this.frameBuffer);
            this.pixelbuffer.close();
            this.pixelbuffer = $$3.createBuffer(() -> "Tracy Frame Capture buffer", 9, p_372813_ * p_372948_ * 4);
        }
    }

    public void capture(RenderTarget p_372980_) {
        if (this.status != Status.WAITING_FOR_CAPTURE || this.capturedThisFrame || p_372980_.getColorTexture() == null) {
            return;
        }
        this.capturedThisFrame = true;
        if (p_372980_.width != this.targetWidth || p_372980_.height != this.targetHeight) {
            this.targetWidth = p_372980_.width;
            this.targetHeight = p_372980_.height;
            this.resize(this.targetWidth, this.targetHeight);
        }
        this.status = Status.WAITING_FOR_COPY;
        CommandEncoder $$1 = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.AutoStorageIndexBuffer $$2 = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer $$3 = $$2.getBuffer(6);
        try (RenderPass $$4 = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Tracy blit", this.frameBufferView, OptionalInt.empty());){
            $$4.setPipeline(RenderPipelines.TRACY_BLIT);
            $$4.setVertexBuffer(0, RenderSystem.getQuadVertexBuffer());
            $$4.setIndexBuffer($$3, $$2.type());
            $$4.bindSampler("InSampler", p_372980_.getColorTextureView());
            $$4.drawIndexed(0, 0, 6, 1);
        }
        $$1.copyTextureToBuffer(this.frameBuffer, this.pixelbuffer, 0, () -> {
            this.status = Status.WAITING_FOR_UPLOAD;
        }, 0);
        this.lastCaptureDelay = 0;
    }

    public void upload() {
        if (this.status != Status.WAITING_FOR_UPLOAD) {
            return;
        }
        this.status = Status.WAITING_FOR_CAPTURE;
        try (GpuBuffer.MappedView $$0 = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.pixelbuffer, true, false);){
            TracyClient.frameImage((ByteBuffer)$$0.data(), (int)this.width, (int)this.height, (int)this.lastCaptureDelay, (boolean)true);
        }
    }

    public void endFrame() {
        ++this.lastCaptureDelay;
        this.capturedThisFrame = false;
        TracyClient.markFrame();
    }

    @Override
    public void close() {
        this.frameBuffer.close();
        this.frameBufferView.close();
        this.pixelbuffer.close();
    }

    static enum Status {
        WAITING_FOR_CAPTURE,
        WAITING_FOR_COPY,
        WAITING_FOR_UPLOAD;

    }
}

