/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.GpuDevice;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class GraphicsWorkarounds {
    private static final List<String> INTEL_GEN11_CORE = List.of("i3-1000g1", "i3-1000g4", "i3-1000ng4", "i3-1005g1", "i3-l13g4", "i5-1030g4", "i5-1030g7", "i5-1030ng7", "i5-1034g1", "i5-1035g1", "i5-1035g4", "i5-1035g7", "i5-1038ng7", "i5-l16g7", "i7-1060g7", "i7-1060ng7", "i7-1065g7", "i7-1068g7", "i7-1068ng7");
    private static final List<String> INTEL_GEN11_ATOM = List.of("x6211e", "x6212re", "x6214re", "x6413e", "x6414re", "x6416re", "x6425e", "x6425re", "x6427fe");
    private static final List<String> INTEL_GEN11_CELERON = List.of("j6412", "j6413", "n4500", "n4505", "n5095", "n5095a", "n5100", "n5105", "n6210", "n6211");
    private static final List<String> INTEL_GEN11_PENTIUM = List.of("6805", "j6426", "n6415", "n6000", "n6005");
    @Nullable
    private static GraphicsWorkarounds instance;
    private final WeakReference<GpuDevice> gpuDevice;
    private final boolean alwaysCreateFreshImmediateBuffer;

    private GraphicsWorkarounds(GpuDevice p_428863_) {
        this.gpuDevice = new WeakReference<GpuDevice>(p_428863_);
        this.alwaysCreateFreshImmediateBuffer = GraphicsWorkarounds.isIntelGen11(p_428863_);
    }

    public static GraphicsWorkarounds get(GpuDevice p_428864_) {
        GraphicsWorkarounds $$1 = instance;
        if ($$1 == null || $$1.gpuDevice.get() != p_428864_) {
            instance = $$1 = new GraphicsWorkarounds(p_428864_);
        }
        return $$1;
    }

    public boolean alwaysCreateFreshImmediateBuffer() {
        return this.alwaysCreateFreshImmediateBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isIntelGen11(GpuDevice p_428865_) {
        String $$1 = GLX._getCpuInfo().toLowerCase(Locale.ROOT);
        String $$2 = p_428865_.getRenderer().toLowerCase(Locale.ROOT);
        if (!$$1.contains("intel")) return false;
        if (!$$2.contains("intel")) return false;
        if ($$2.contains("mesa")) {
            return false;
        }
        if ($$2.endsWith("gen11")) {
            return true;
        }
        if (!$$2.contains("uhd graphics") && !$$2.contains("iris")) {
            return false;
        }
        if ($$1.contains("atom")) {
            if (INTEL_GEN11_ATOM.stream().anyMatch($$1::contains)) return true;
        }
        if ($$1.contains("celeron")) {
            if (INTEL_GEN11_CELERON.stream().anyMatch($$1::contains)) return true;
        }
        if ($$1.contains("pentium")) {
            if (INTEL_GEN11_PENTIUM.stream().anyMatch($$1::contains)) return true;
        }
        if (!INTEL_GEN11_CORE.stream().anyMatch($$1::contains)) return false;
        return true;
    }
}

